/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.BurninDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDestinationType;
import software.amazon.awssdk.services.mediaconvert.model.DvbSubDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.EmbeddedDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.SccDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.TeletextDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.TtmlDestinationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptionDestinationSettings> {
    private static final SdkField<BurninDestinationSettings> BURNIN_DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionDestinationSettings.getter(CaptionDestinationSettings::burninDestinationSettings)).setter(CaptionDestinationSettings.setter(Builder::burninDestinationSettings)).constructor(BurninDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("burninDestinationSettings").build()}).build();
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CaptionDestinationSettings.getter(CaptionDestinationSettings::destinationTypeAsString)).setter(CaptionDestinationSettings.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()}).build();
    private static final SdkField<DvbSubDestinationSettings> DVB_SUB_DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionDestinationSettings.getter(CaptionDestinationSettings::dvbSubDestinationSettings)).setter(CaptionDestinationSettings.setter(Builder::dvbSubDestinationSettings)).constructor(DvbSubDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubDestinationSettings").build()}).build();
    private static final SdkField<EmbeddedDestinationSettings> EMBEDDED_DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionDestinationSettings.getter(CaptionDestinationSettings::embeddedDestinationSettings)).setter(CaptionDestinationSettings.setter(Builder::embeddedDestinationSettings)).constructor(EmbeddedDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedDestinationSettings").build()}).build();
    private static final SdkField<SccDestinationSettings> SCC_DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionDestinationSettings.getter(CaptionDestinationSettings::sccDestinationSettings)).setter(CaptionDestinationSettings.setter(Builder::sccDestinationSettings)).constructor(SccDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sccDestinationSettings").build()}).build();
    private static final SdkField<TeletextDestinationSettings> TELETEXT_DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionDestinationSettings.getter(CaptionDestinationSettings::teletextDestinationSettings)).setter(CaptionDestinationSettings.setter(Builder::teletextDestinationSettings)).constructor(TeletextDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextDestinationSettings").build()}).build();
    private static final SdkField<TtmlDestinationSettings> TTML_DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionDestinationSettings.getter(CaptionDestinationSettings::ttmlDestinationSettings)).setter(CaptionDestinationSettings.setter(Builder::ttmlDestinationSettings)).constructor(TtmlDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttmlDestinationSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BURNIN_DESTINATION_SETTINGS_FIELD, DESTINATION_TYPE_FIELD, DVB_SUB_DESTINATION_SETTINGS_FIELD, EMBEDDED_DESTINATION_SETTINGS_FIELD, SCC_DESTINATION_SETTINGS_FIELD, TELETEXT_DESTINATION_SETTINGS_FIELD, TTML_DESTINATION_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final BurninDestinationSettings burninDestinationSettings;
    private final String destinationType;
    private final DvbSubDestinationSettings dvbSubDestinationSettings;
    private final EmbeddedDestinationSettings embeddedDestinationSettings;
    private final SccDestinationSettings sccDestinationSettings;
    private final TeletextDestinationSettings teletextDestinationSettings;
    private final TtmlDestinationSettings ttmlDestinationSettings;

    private CaptionDestinationSettings(BuilderImpl builder) {
        this.burninDestinationSettings = builder.burninDestinationSettings;
        this.destinationType = builder.destinationType;
        this.dvbSubDestinationSettings = builder.dvbSubDestinationSettings;
        this.embeddedDestinationSettings = builder.embeddedDestinationSettings;
        this.sccDestinationSettings = builder.sccDestinationSettings;
        this.teletextDestinationSettings = builder.teletextDestinationSettings;
        this.ttmlDestinationSettings = builder.ttmlDestinationSettings;
    }

    public BurninDestinationSettings burninDestinationSettings() {
        return this.burninDestinationSettings;
    }

    public CaptionDestinationType destinationType() {
        return CaptionDestinationType.fromValue(this.destinationType);
    }

    public String destinationTypeAsString() {
        return this.destinationType;
    }

    public DvbSubDestinationSettings dvbSubDestinationSettings() {
        return this.dvbSubDestinationSettings;
    }

    public EmbeddedDestinationSettings embeddedDestinationSettings() {
        return this.embeddedDestinationSettings;
    }

    public SccDestinationSettings sccDestinationSettings() {
        return this.sccDestinationSettings;
    }

    public TeletextDestinationSettings teletextDestinationSettings() {
        return this.teletextDestinationSettings;
    }

    public TtmlDestinationSettings ttmlDestinationSettings() {
        return this.ttmlDestinationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.burninDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSubDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddedDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sccDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttmlDestinationSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDestinationSettings)) {
            return false;
        }
        CaptionDestinationSettings other = (CaptionDestinationSettings)obj;
        return Objects.equals(this.burninDestinationSettings(), other.burninDestinationSettings()) && Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.dvbSubDestinationSettings(), other.dvbSubDestinationSettings()) && Objects.equals(this.embeddedDestinationSettings(), other.embeddedDestinationSettings()) && Objects.equals(this.sccDestinationSettings(), other.sccDestinationSettings()) && Objects.equals(this.teletextDestinationSettings(), other.teletextDestinationSettings()) && Objects.equals(this.ttmlDestinationSettings(), other.ttmlDestinationSettings());
    }

    public String toString() {
        return ToString.builder((String)"CaptionDestinationSettings").add("BurninDestinationSettings", (Object)this.burninDestinationSettings()).add("DestinationType", (Object)this.destinationTypeAsString()).add("DvbSubDestinationSettings", (Object)this.dvbSubDestinationSettings()).add("EmbeddedDestinationSettings", (Object)this.embeddedDestinationSettings()).add("SccDestinationSettings", (Object)this.sccDestinationSettings()).add("TeletextDestinationSettings", (Object)this.teletextDestinationSettings()).add("TtmlDestinationSettings", (Object)this.ttmlDestinationSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BurninDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.burninDestinationSettings()));
            }
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "DvbSubDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbSubDestinationSettings()));
            }
            case "EmbeddedDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.embeddedDestinationSettings()));
            }
            case "SccDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.sccDestinationSettings()));
            }
            case "TeletextDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.teletextDestinationSettings()));
            }
            case "TtmlDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.ttmlDestinationSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionDestinationSettings, T> g) {
        return obj -> g.apply((CaptionDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BurninDestinationSettings burninDestinationSettings;
        private String destinationType;
        private DvbSubDestinationSettings dvbSubDestinationSettings;
        private EmbeddedDestinationSettings embeddedDestinationSettings;
        private SccDestinationSettings sccDestinationSettings;
        private TeletextDestinationSettings teletextDestinationSettings;
        private TtmlDestinationSettings ttmlDestinationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDestinationSettings model) {
            this.burninDestinationSettings(model.burninDestinationSettings);
            this.destinationType(model.destinationType);
            this.dvbSubDestinationSettings(model.dvbSubDestinationSettings);
            this.embeddedDestinationSettings(model.embeddedDestinationSettings);
            this.sccDestinationSettings(model.sccDestinationSettings);
            this.teletextDestinationSettings(model.teletextDestinationSettings);
            this.ttmlDestinationSettings(model.ttmlDestinationSettings);
        }

        public final BurninDestinationSettings.Builder getBurninDestinationSettings() {
            return this.burninDestinationSettings != null ? this.burninDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder burninDestinationSettings(BurninDestinationSettings burninDestinationSettings) {
            this.burninDestinationSettings = burninDestinationSettings;
            return this;
        }

        public final void setBurninDestinationSettings(BurninDestinationSettings.BuilderImpl burninDestinationSettings) {
            this.burninDestinationSettings = burninDestinationSettings != null ? burninDestinationSettings.build() : null;
        }

        public final String getDestinationTypeAsString() {
            return this.destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(CaptionDestinationType destinationType) {
            this.destinationType(destinationType.toString());
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final DvbSubDestinationSettings.Builder getDvbSubDestinationSettings() {
            return this.dvbSubDestinationSettings != null ? this.dvbSubDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSubDestinationSettings(DvbSubDestinationSettings dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings;
            return this;
        }

        public final void setDvbSubDestinationSettings(DvbSubDestinationSettings.BuilderImpl dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings != null ? dvbSubDestinationSettings.build() : null;
        }

        public final EmbeddedDestinationSettings.Builder getEmbeddedDestinationSettings() {
            return this.embeddedDestinationSettings != null ? this.embeddedDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder embeddedDestinationSettings(EmbeddedDestinationSettings embeddedDestinationSettings) {
            this.embeddedDestinationSettings = embeddedDestinationSettings;
            return this;
        }

        public final void setEmbeddedDestinationSettings(EmbeddedDestinationSettings.BuilderImpl embeddedDestinationSettings) {
            this.embeddedDestinationSettings = embeddedDestinationSettings != null ? embeddedDestinationSettings.build() : null;
        }

        public final SccDestinationSettings.Builder getSccDestinationSettings() {
            return this.sccDestinationSettings != null ? this.sccDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder sccDestinationSettings(SccDestinationSettings sccDestinationSettings) {
            this.sccDestinationSettings = sccDestinationSettings;
            return this;
        }

        public final void setSccDestinationSettings(SccDestinationSettings.BuilderImpl sccDestinationSettings) {
            this.sccDestinationSettings = sccDestinationSettings != null ? sccDestinationSettings.build() : null;
        }

        public final TeletextDestinationSettings.Builder getTeletextDestinationSettings() {
            return this.teletextDestinationSettings != null ? this.teletextDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder teletextDestinationSettings(TeletextDestinationSettings teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings;
            return this;
        }

        public final void setTeletextDestinationSettings(TeletextDestinationSettings.BuilderImpl teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings != null ? teletextDestinationSettings.build() : null;
        }

        public final TtmlDestinationSettings.Builder getTtmlDestinationSettings() {
            return this.ttmlDestinationSettings != null ? this.ttmlDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder ttmlDestinationSettings(TtmlDestinationSettings ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings;
            return this;
        }

        public final void setTtmlDestinationSettings(TtmlDestinationSettings.BuilderImpl ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings != null ? ttmlDestinationSettings.build() : null;
        }

        public CaptionDestinationSettings build() {
            return new CaptionDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptionDestinationSettings> {
        public Builder burninDestinationSettings(BurninDestinationSettings var1);

        default public Builder burninDestinationSettings(Consumer<BurninDestinationSettings.Builder> burninDestinationSettings) {
            return this.burninDestinationSettings((BurninDestinationSettings)((BurninDestinationSettings.Builder)BurninDestinationSettings.builder().applyMutation(burninDestinationSettings)).build());
        }

        public Builder destinationType(String var1);

        public Builder destinationType(CaptionDestinationType var1);

        public Builder dvbSubDestinationSettings(DvbSubDestinationSettings var1);

        default public Builder dvbSubDestinationSettings(Consumer<DvbSubDestinationSettings.Builder> dvbSubDestinationSettings) {
            return this.dvbSubDestinationSettings((DvbSubDestinationSettings)((DvbSubDestinationSettings.Builder)DvbSubDestinationSettings.builder().applyMutation(dvbSubDestinationSettings)).build());
        }

        public Builder embeddedDestinationSettings(EmbeddedDestinationSettings var1);

        default public Builder embeddedDestinationSettings(Consumer<EmbeddedDestinationSettings.Builder> embeddedDestinationSettings) {
            return this.embeddedDestinationSettings((EmbeddedDestinationSettings)((EmbeddedDestinationSettings.Builder)EmbeddedDestinationSettings.builder().applyMutation(embeddedDestinationSettings)).build());
        }

        public Builder sccDestinationSettings(SccDestinationSettings var1);

        default public Builder sccDestinationSettings(Consumer<SccDestinationSettings.Builder> sccDestinationSettings) {
            return this.sccDestinationSettings((SccDestinationSettings)((SccDestinationSettings.Builder)SccDestinationSettings.builder().applyMutation(sccDestinationSettings)).build());
        }

        public Builder teletextDestinationSettings(TeletextDestinationSettings var1);

        default public Builder teletextDestinationSettings(Consumer<TeletextDestinationSettings.Builder> teletextDestinationSettings) {
            return this.teletextDestinationSettings((TeletextDestinationSettings)((TeletextDestinationSettings.Builder)TeletextDestinationSettings.builder().applyMutation(teletextDestinationSettings)).build());
        }

        public Builder ttmlDestinationSettings(TtmlDestinationSettings var1);

        default public Builder ttmlDestinationSettings(Consumer<TtmlDestinationSettings.Builder> ttmlDestinationSettings) {
            return this.ttmlDestinationSettings((TtmlDestinationSettings)((TtmlDestinationSettings.Builder)TtmlDestinationSettings.builder().applyMutation(ttmlDestinationSettings)).build());
        }
    }
}

