/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.DestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.HlsAdMarkers;
import software.amazon.awssdk.services.mediaconvert.model.HlsAdditionalManifest;
import software.amazon.awssdk.services.mediaconvert.model.HlsAudioOnlyHeader;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageSetting;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionSegmentLengthControl;
import software.amazon.awssdk.services.mediaconvert.model.HlsClientCache;
import software.amazon.awssdk.services.mediaconvert.model.HlsCodecSpecification;
import software.amazon.awssdk.services.mediaconvert.model.HlsDirectoryStructure;
import software.amazon.awssdk.services.mediaconvert.model.HlsEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.HlsImageBasedTrickPlay;
import software.amazon.awssdk.services.mediaconvert.model.HlsImageBasedTrickPlaySettings;
import software.amazon.awssdk.services.mediaconvert.model.HlsManifestCompression;
import software.amazon.awssdk.services.mediaconvert.model.HlsManifestDurationFormat;
import software.amazon.awssdk.services.mediaconvert.model.HlsOutputSelection;
import software.amazon.awssdk.services.mediaconvert.model.HlsProgramDateTime;
import software.amazon.awssdk.services.mediaconvert.model.HlsProgressiveWriteHlsManifest;
import software.amazon.awssdk.services.mediaconvert.model.HlsSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.HlsSegmentLengthControl;
import software.amazon.awssdk.services.mediaconvert.model.HlsStreamInfResolution;
import software.amazon.awssdk.services.mediaconvert.model.HlsTargetDurationCompatibilityMode;
import software.amazon.awssdk.services.mediaconvert.model.HlsTimedMetadataId3Frame;
import software.amazon.awssdk.services.mediaconvert.model.___listOfHlsAdMarkersCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfHlsAdditionalManifestCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfHlsCaptionLanguageMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdMarkers").getter(HlsGroupSettings.getter(HlsGroupSettings::adMarkersAsStrings)).setter(HlsGroupSettings.setter(Builder::adMarkersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HlsAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalManifests").getter(HlsGroupSettings.getter(HlsGroupSettings::additionalManifests)).setter(HlsGroupSettings.setter(Builder::additionalManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HlsAdditionalManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUDIO_ONLY_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioOnlyHeader").getter(HlsGroupSettings.getter(HlsGroupSettings::audioOnlyHeaderAsString)).setter(HlsGroupSettings.setter(Builder::audioOnlyHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyHeader").build()}).build();
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrl").getter(HlsGroupSettings.getter(HlsGroupSettings::baseUrl)).setter(HlsGroupSettings.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()}).build();
    private static final SdkField<List<HlsCaptionLanguageMapping>> CAPTION_LANGUAGE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionLanguageMappings").getter(HlsGroupSettings.getter(HlsGroupSettings::captionLanguageMappings)).setter(HlsGroupSettings.setter(Builder::captionLanguageMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HlsCaptionLanguageMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CAPTION_LANGUAGE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptionLanguageSetting").getter(HlsGroupSettings.getter(HlsGroupSettings::captionLanguageSettingAsString)).setter(HlsGroupSettings.setter(Builder::captionLanguageSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageSetting").build()}).build();
    private static final SdkField<String> CAPTION_SEGMENT_LENGTH_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptionSegmentLengthControl").getter(HlsGroupSettings.getter(HlsGroupSettings::captionSegmentLengthControlAsString)).setter(HlsGroupSettings.setter(Builder::captionSegmentLengthControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSegmentLengthControl").build()}).build();
    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCache").getter(HlsGroupSettings.getter(HlsGroupSettings::clientCacheAsString)).setter(HlsGroupSettings.setter(Builder::clientCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()}).build();
    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecSpecification").getter(HlsGroupSettings.getter(HlsGroupSettings::codecSpecificationAsString)).setter(HlsGroupSettings.setter(Builder::codecSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(HlsGroupSettings.getter(HlsGroupSettings::destination)).setter(HlsGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSettings").getter(HlsGroupSettings.getter(HlsGroupSettings::destinationSettings)).setter(HlsGroupSettings.setter(Builder::destinationSettings)).constructor(DestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<String> DIRECTORY_STRUCTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryStructure").getter(HlsGroupSettings.getter(HlsGroupSettings::directoryStructureAsString)).setter(HlsGroupSettings.setter(Builder::directoryStructure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryStructure").build()}).build();
    private static final SdkField<HlsEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(HlsGroupSettings.getter(HlsGroupSettings::encryption)).setter(HlsGroupSettings.setter(Builder::encryption)).constructor(HlsEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<String> IMAGE_BASED_TRICK_PLAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBasedTrickPlay").getter(HlsGroupSettings.getter(HlsGroupSettings::imageBasedTrickPlayAsString)).setter(HlsGroupSettings.setter(Builder::imageBasedTrickPlay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlay").build()}).build();
    private static final SdkField<HlsImageBasedTrickPlaySettings> IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageBasedTrickPlaySettings").getter(HlsGroupSettings.getter(HlsGroupSettings::imageBasedTrickPlaySettings)).setter(HlsGroupSettings.setter(Builder::imageBasedTrickPlaySettings)).constructor(HlsImageBasedTrickPlaySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlaySettings").build()}).build();
    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestCompression").getter(HlsGroupSettings.getter(HlsGroupSettings::manifestCompressionAsString)).setter(HlsGroupSettings.setter(Builder::manifestCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build()}).build();
    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestDurationFormat").getter(HlsGroupSettings.getter(HlsGroupSettings::manifestDurationFormatAsString)).setter(HlsGroupSettings.setter(Builder::manifestDurationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build()}).build();
    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinFinalSegmentLength").getter(HlsGroupSettings.getter(HlsGroupSettings::minFinalSegmentLength)).setter(HlsGroupSettings.setter(Builder::minFinalSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build()}).build();
    private static final SdkField<Integer> MIN_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSegmentLength").getter(HlsGroupSettings.getter(HlsGroupSettings::minSegmentLength)).setter(HlsGroupSettings.setter(Builder::minSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSegmentLength").build()}).build();
    private static final SdkField<String> OUTPUT_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputSelection").getter(HlsGroupSettings.getter(HlsGroupSettings::outputSelectionAsString)).setter(HlsGroupSettings.setter(Builder::outputSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSelection").build()}).build();
    private static final SdkField<String> PROGRAM_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramDateTime").getter(HlsGroupSettings.getter(HlsGroupSettings::programDateTimeAsString)).setter(HlsGroupSettings.setter(Builder::programDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTime").build()}).build();
    private static final SdkField<Integer> PROGRAM_DATE_TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramDateTimePeriod").getter(HlsGroupSettings.getter(HlsGroupSettings::programDateTimePeriod)).setter(HlsGroupSettings.setter(Builder::programDateTimePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimePeriod").build()}).build();
    private static final SdkField<String> PROGRESSIVE_WRITE_HLS_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgressiveWriteHlsManifest").getter(HlsGroupSettings.getter(HlsGroupSettings::progressiveWriteHlsManifestAsString)).setter(HlsGroupSettings.setter(Builder::progressiveWriteHlsManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressiveWriteHlsManifest").build()}).build();
    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentControl").getter(HlsGroupSettings.getter(HlsGroupSettings::segmentControlAsString)).setter(HlsGroupSettings.setter(Builder::segmentControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentLength").getter(HlsGroupSettings.getter(HlsGroupSettings::segmentLength)).setter(HlsGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> SEGMENT_LENGTH_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentLengthControl").getter(HlsGroupSettings.getter(HlsGroupSettings::segmentLengthControlAsString)).setter(HlsGroupSettings.setter(Builder::segmentLengthControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthControl").build()}).build();
    private static final SdkField<Integer> SEGMENTS_PER_SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentsPerSubdirectory").getter(HlsGroupSettings.getter(HlsGroupSettings::segmentsPerSubdirectory)).setter(HlsGroupSettings.setter(Builder::segmentsPerSubdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentsPerSubdirectory").build()}).build();
    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamInfResolution").getter(HlsGroupSettings.getter(HlsGroupSettings::streamInfResolutionAsString)).setter(HlsGroupSettings.setter(Builder::streamInfResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build()}).build();
    private static final SdkField<String> TARGET_DURATION_COMPATIBILITY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDurationCompatibilityMode").getter(HlsGroupSettings.getter(HlsGroupSettings::targetDurationCompatibilityModeAsString)).setter(HlsGroupSettings.setter(Builder::targetDurationCompatibilityMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDurationCompatibilityMode").build()}).build();
    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadataId3Frame").getter(HlsGroupSettings.getter(HlsGroupSettings::timedMetadataId3FrameAsString)).setter(HlsGroupSettings.setter(Builder::timedMetadataId3Frame)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build()}).build();
    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimedMetadataId3Period").getter(HlsGroupSettings.getter(HlsGroupSettings::timedMetadataId3Period)).setter(HlsGroupSettings.setter(Builder::timedMetadataId3Period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build()}).build();
    private static final SdkField<Integer> TIMESTAMP_DELTA_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimestampDeltaMilliseconds").getter(HlsGroupSettings.getter(HlsGroupSettings::timestampDeltaMilliseconds)).setter(HlsGroupSettings.setter(Builder::timestampDeltaMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampDeltaMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, ADDITIONAL_MANIFESTS_FIELD, AUDIO_ONLY_HEADER_FIELD, BASE_URL_FIELD, CAPTION_LANGUAGE_MAPPINGS_FIELD, CAPTION_LANGUAGE_SETTING_FIELD, CAPTION_SEGMENT_LENGTH_CONTROL_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, DIRECTORY_STRUCTURE_FIELD, ENCRYPTION_FIELD, IMAGE_BASED_TRICK_PLAY_FIELD, IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, MIN_SEGMENT_LENGTH_FIELD, OUTPUT_SELECTION_FIELD, PROGRAM_DATE_TIME_FIELD, PROGRAM_DATE_TIME_PERIOD_FIELD, PROGRESSIVE_WRITE_HLS_MANIFEST_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_CONTROL_FIELD, SEGMENTS_PER_SUBDIRECTORY_FIELD, STREAM_INF_RESOLUTION_FIELD, TARGET_DURATION_COMPATIBILITY_MODE_FIELD, TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD, TIMESTAMP_DELTA_MILLISECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> adMarkers;
    private final List<HlsAdditionalManifest> additionalManifests;
    private final String audioOnlyHeader;
    private final String baseUrl;
    private final List<HlsCaptionLanguageMapping> captionLanguageMappings;
    private final String captionLanguageSetting;
    private final String captionSegmentLengthControl;
    private final String clientCache;
    private final String codecSpecification;
    private final String destination;
    private final DestinationSettings destinationSettings;
    private final String directoryStructure;
    private final HlsEncryptionSettings encryption;
    private final String imageBasedTrickPlay;
    private final HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Double minFinalSegmentLength;
    private final Integer minSegmentLength;
    private final String outputSelection;
    private final String programDateTime;
    private final Integer programDateTimePeriod;
    private final String progressiveWriteHlsManifest;
    private final String segmentControl;
    private final Integer segmentLength;
    private final String segmentLengthControl;
    private final Integer segmentsPerSubdirectory;
    private final String streamInfResolution;
    private final String targetDurationCompatibilityMode;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;
    private final Integer timestampDeltaMilliseconds;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.additionalManifests = builder.additionalManifests;
        this.audioOnlyHeader = builder.audioOnlyHeader;
        this.baseUrl = builder.baseUrl;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.captionSegmentLengthControl = builder.captionSegmentLengthControl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.directoryStructure = builder.directoryStructure;
        this.encryption = builder.encryption;
        this.imageBasedTrickPlay = builder.imageBasedTrickPlay;
        this.imageBasedTrickPlaySettings = builder.imageBasedTrickPlaySettings;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.minSegmentLength = builder.minSegmentLength;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.progressiveWriteHlsManifest = builder.progressiveWriteHlsManifest;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthControl = builder.segmentLengthControl;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.targetDurationCompatibilityMode = builder.targetDurationCompatibilityMode;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
    }

    public final List<HlsAdMarkers> adMarkers() {
        return ___listOfHlsAdMarkersCopier.copyStringToEnum(this.adMarkers);
    }

    public final boolean hasAdMarkers() {
        return this.adMarkers != null && !(this.adMarkers instanceof SdkAutoConstructList);
    }

    public final List<String> adMarkersAsStrings() {
        return this.adMarkers;
    }

    public final boolean hasAdditionalManifests() {
        return this.additionalManifests != null && !(this.additionalManifests instanceof SdkAutoConstructList);
    }

    public final List<HlsAdditionalManifest> additionalManifests() {
        return this.additionalManifests;
    }

    public final HlsAudioOnlyHeader audioOnlyHeader() {
        return HlsAudioOnlyHeader.fromValue(this.audioOnlyHeader);
    }

    public final String audioOnlyHeaderAsString() {
        return this.audioOnlyHeader;
    }

    public final String baseUrl() {
        return this.baseUrl;
    }

    public final boolean hasCaptionLanguageMappings() {
        return this.captionLanguageMappings != null && !(this.captionLanguageMappings instanceof SdkAutoConstructList);
    }

    public final List<HlsCaptionLanguageMapping> captionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public final HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(this.captionLanguageSetting);
    }

    public final String captionLanguageSettingAsString() {
        return this.captionLanguageSetting;
    }

    public final HlsCaptionSegmentLengthControl captionSegmentLengthControl() {
        return HlsCaptionSegmentLengthControl.fromValue(this.captionSegmentLengthControl);
    }

    public final String captionSegmentLengthControlAsString() {
        return this.captionSegmentLengthControl;
    }

    public final HlsClientCache clientCache() {
        return HlsClientCache.fromValue(this.clientCache);
    }

    public final String clientCacheAsString() {
        return this.clientCache;
    }

    public final HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(this.codecSpecification);
    }

    public final String codecSpecificationAsString() {
        return this.codecSpecification;
    }

    public final String destination() {
        return this.destination;
    }

    public final DestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public final HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(this.directoryStructure);
    }

    public final String directoryStructureAsString() {
        return this.directoryStructure;
    }

    public final HlsEncryptionSettings encryption() {
        return this.encryption;
    }

    public final HlsImageBasedTrickPlay imageBasedTrickPlay() {
        return HlsImageBasedTrickPlay.fromValue(this.imageBasedTrickPlay);
    }

    public final String imageBasedTrickPlayAsString() {
        return this.imageBasedTrickPlay;
    }

    public final HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings() {
        return this.imageBasedTrickPlaySettings;
    }

    public final HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(this.manifestCompression);
    }

    public final String manifestCompressionAsString() {
        return this.manifestCompression;
    }

    public final HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public final String manifestDurationFormatAsString() {
        return this.manifestDurationFormat;
    }

    public final Double minFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public final Integer minSegmentLength() {
        return this.minSegmentLength;
    }

    public final HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(this.outputSelection);
    }

    public final String outputSelectionAsString() {
        return this.outputSelection;
    }

    public final HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(this.programDateTime);
    }

    public final String programDateTimeAsString() {
        return this.programDateTime;
    }

    public final Integer programDateTimePeriod() {
        return this.programDateTimePeriod;
    }

    public final HlsProgressiveWriteHlsManifest progressiveWriteHlsManifest() {
        return HlsProgressiveWriteHlsManifest.fromValue(this.progressiveWriteHlsManifest);
    }

    public final String progressiveWriteHlsManifestAsString() {
        return this.progressiveWriteHlsManifest;
    }

    public final HlsSegmentControl segmentControl() {
        return HlsSegmentControl.fromValue(this.segmentControl);
    }

    public final String segmentControlAsString() {
        return this.segmentControl;
    }

    public final Integer segmentLength() {
        return this.segmentLength;
    }

    public final HlsSegmentLengthControl segmentLengthControl() {
        return HlsSegmentLengthControl.fromValue(this.segmentLengthControl);
    }

    public final String segmentLengthControlAsString() {
        return this.segmentLengthControl;
    }

    public final Integer segmentsPerSubdirectory() {
        return this.segmentsPerSubdirectory;
    }

    public final HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public final String streamInfResolutionAsString() {
        return this.streamInfResolution;
    }

    public final HlsTargetDurationCompatibilityMode targetDurationCompatibilityMode() {
        return HlsTargetDurationCompatibilityMode.fromValue(this.targetDurationCompatibilityMode);
    }

    public final String targetDurationCompatibilityModeAsString() {
        return this.targetDurationCompatibilityMode;
    }

    public final HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public final String timedMetadataId3FrameAsString() {
        return this.timedMetadataId3Frame;
    }

    public final Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public final Integer timestampDeltaMilliseconds() {
        return this.timestampDeltaMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdMarkers() ? this.adMarkersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalManifests() ? this.additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyHeaderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionLanguageMappings() ? this.captionLanguageMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSegmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryStructureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBasedTrickPlayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBasedTrickPlaySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressiveWriteHlsManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDurationCompatibilityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampDeltaMilliseconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings)obj;
        return this.hasAdMarkers() == other.hasAdMarkers() && Objects.equals(this.adMarkersAsStrings(), other.adMarkersAsStrings()) && this.hasAdditionalManifests() == other.hasAdditionalManifests() && Objects.equals(this.additionalManifests(), other.additionalManifests()) && Objects.equals(this.audioOnlyHeaderAsString(), other.audioOnlyHeaderAsString()) && Objects.equals(this.baseUrl(), other.baseUrl()) && this.hasCaptionLanguageMappings() == other.hasCaptionLanguageMappings() && Objects.equals(this.captionLanguageMappings(), other.captionLanguageMappings()) && Objects.equals(this.captionLanguageSettingAsString(), other.captionLanguageSettingAsString()) && Objects.equals(this.captionSegmentLengthControlAsString(), other.captionSegmentLengthControlAsString()) && Objects.equals(this.clientCacheAsString(), other.clientCacheAsString()) && Objects.equals(this.codecSpecificationAsString(), other.codecSpecificationAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.directoryStructureAsString(), other.directoryStructureAsString()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.imageBasedTrickPlayAsString(), other.imageBasedTrickPlayAsString()) && Objects.equals(this.imageBasedTrickPlaySettings(), other.imageBasedTrickPlaySettings()) && Objects.equals(this.manifestCompressionAsString(), other.manifestCompressionAsString()) && Objects.equals(this.manifestDurationFormatAsString(), other.manifestDurationFormatAsString()) && Objects.equals(this.minFinalSegmentLength(), other.minFinalSegmentLength()) && Objects.equals(this.minSegmentLength(), other.minSegmentLength()) && Objects.equals(this.outputSelectionAsString(), other.outputSelectionAsString()) && Objects.equals(this.programDateTimeAsString(), other.programDateTimeAsString()) && Objects.equals(this.programDateTimePeriod(), other.programDateTimePeriod()) && Objects.equals(this.progressiveWriteHlsManifestAsString(), other.progressiveWriteHlsManifestAsString()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentLengthControlAsString(), other.segmentLengthControlAsString()) && Objects.equals(this.segmentsPerSubdirectory(), other.segmentsPerSubdirectory()) && Objects.equals(this.streamInfResolutionAsString(), other.streamInfResolutionAsString()) && Objects.equals(this.targetDurationCompatibilityModeAsString(), other.targetDurationCompatibilityModeAsString()) && Objects.equals(this.timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period()) && Objects.equals(this.timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds());
    }

    public final String toString() {
        return ToString.builder((String)"HlsGroupSettings").add("AdMarkers", this.hasAdMarkers() ? this.adMarkersAsStrings() : null).add("AdditionalManifests", this.hasAdditionalManifests() ? this.additionalManifests() : null).add("AudioOnlyHeader", (Object)this.audioOnlyHeaderAsString()).add("BaseUrl", (Object)this.baseUrl()).add("CaptionLanguageMappings", this.hasCaptionLanguageMappings() ? this.captionLanguageMappings() : null).add("CaptionLanguageSetting", (Object)this.captionLanguageSettingAsString()).add("CaptionSegmentLengthControl", (Object)this.captionSegmentLengthControlAsString()).add("ClientCache", (Object)this.clientCacheAsString()).add("CodecSpecification", (Object)this.codecSpecificationAsString()).add("Destination", (Object)this.destination()).add("DestinationSettings", (Object)this.destinationSettings()).add("DirectoryStructure", (Object)this.directoryStructureAsString()).add("Encryption", (Object)this.encryption()).add("ImageBasedTrickPlay", (Object)this.imageBasedTrickPlayAsString()).add("ImageBasedTrickPlaySettings", (Object)this.imageBasedTrickPlaySettings()).add("ManifestCompression", (Object)this.manifestCompressionAsString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatAsString()).add("MinFinalSegmentLength", (Object)this.minFinalSegmentLength()).add("MinSegmentLength", (Object)this.minSegmentLength()).add("OutputSelection", (Object)this.outputSelectionAsString()).add("ProgramDateTime", (Object)this.programDateTimeAsString()).add("ProgramDateTimePeriod", (Object)this.programDateTimePeriod()).add("ProgressiveWriteHlsManifest", (Object)this.progressiveWriteHlsManifestAsString()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentLengthControl", (Object)this.segmentLengthControlAsString()).add("SegmentsPerSubdirectory", (Object)this.segmentsPerSubdirectory()).add("StreamInfResolution", (Object)this.streamInfResolutionAsString()).add("TargetDurationCompatibilityMode", (Object)this.targetDurationCompatibilityModeAsString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameAsString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).add("TimestampDeltaMilliseconds", (Object)this.timestampDeltaMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsStrings()));
            }
            case "AdditionalManifests": {
                return Optional.ofNullable(clazz.cast(this.additionalManifests()));
            }
            case "AudioOnlyHeader": {
                return Optional.ofNullable(clazz.cast(this.audioOnlyHeaderAsString()));
            }
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "CaptionLanguageMappings": {
                return Optional.ofNullable(clazz.cast(this.captionLanguageMappings()));
            }
            case "CaptionLanguageSetting": {
                return Optional.ofNullable(clazz.cast(this.captionLanguageSettingAsString()));
            }
            case "CaptionSegmentLengthControl": {
                return Optional.ofNullable(clazz.cast(this.captionSegmentLengthControlAsString()));
            }
            case "ClientCache": {
                return Optional.ofNullable(clazz.cast(this.clientCacheAsString()));
            }
            case "CodecSpecification": {
                return Optional.ofNullable(clazz.cast(this.codecSpecificationAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "DirectoryStructure": {
                return Optional.ofNullable(clazz.cast(this.directoryStructureAsString()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "ImageBasedTrickPlay": {
                return Optional.ofNullable(clazz.cast(this.imageBasedTrickPlayAsString()));
            }
            case "ImageBasedTrickPlaySettings": {
                return Optional.ofNullable(clazz.cast(this.imageBasedTrickPlaySettings()));
            }
            case "ManifestCompression": {
                return Optional.ofNullable(clazz.cast(this.manifestCompressionAsString()));
            }
            case "ManifestDurationFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestDurationFormatAsString()));
            }
            case "MinFinalSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minFinalSegmentLength()));
            }
            case "MinSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minSegmentLength()));
            }
            case "OutputSelection": {
                return Optional.ofNullable(clazz.cast(this.outputSelectionAsString()));
            }
            case "ProgramDateTime": {
                return Optional.ofNullable(clazz.cast(this.programDateTimeAsString()));
            }
            case "ProgramDateTimePeriod": {
                return Optional.ofNullable(clazz.cast(this.programDateTimePeriod()));
            }
            case "ProgressiveWriteHlsManifest": {
                return Optional.ofNullable(clazz.cast(this.progressiveWriteHlsManifestAsString()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "SegmentLengthControl": {
                return Optional.ofNullable(clazz.cast(this.segmentLengthControlAsString()));
            }
            case "SegmentsPerSubdirectory": {
                return Optional.ofNullable(clazz.cast(this.segmentsPerSubdirectory()));
            }
            case "StreamInfResolution": {
                return Optional.ofNullable(clazz.cast(this.streamInfResolutionAsString()));
            }
            case "TargetDurationCompatibilityMode": {
                return Optional.ofNullable(clazz.cast(this.targetDurationCompatibilityModeAsString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3FrameAsString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3Period()));
            }
            case "TimestampDeltaMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.timestampDeltaMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsGroupSettings, T> g) {
        return obj -> g.apply((HlsGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();
        private List<HlsAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();
        private String audioOnlyHeader;
        private String baseUrl;
        private List<HlsCaptionLanguageMapping> captionLanguageMappings = DefaultSdkAutoConstructList.getInstance();
        private String captionLanguageSetting;
        private String captionSegmentLengthControl;
        private String clientCache;
        private String codecSpecification;
        private String destination;
        private DestinationSettings destinationSettings;
        private String directoryStructure;
        private HlsEncryptionSettings encryption;
        private String imageBasedTrickPlay;
        private HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Double minFinalSegmentLength;
        private Integer minSegmentLength;
        private String outputSelection;
        private String programDateTime;
        private Integer programDateTimePeriod;
        private String progressiveWriteHlsManifest;
        private String segmentControl;
        private Integer segmentLength;
        private String segmentLengthControl;
        private Integer segmentsPerSubdirectory;
        private String streamInfResolution;
        private String targetDurationCompatibilityMode;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;
        private Integer timestampDeltaMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            this.adMarkersWithStrings(model.adMarkers);
            this.additionalManifests(model.additionalManifests);
            this.audioOnlyHeader(model.audioOnlyHeader);
            this.baseUrl(model.baseUrl);
            this.captionLanguageMappings(model.captionLanguageMappings);
            this.captionLanguageSetting(model.captionLanguageSetting);
            this.captionSegmentLengthControl(model.captionSegmentLengthControl);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.destination(model.destination);
            this.destinationSettings(model.destinationSettings);
            this.directoryStructure(model.directoryStructure);
            this.encryption(model.encryption);
            this.imageBasedTrickPlay(model.imageBasedTrickPlay);
            this.imageBasedTrickPlaySettings(model.imageBasedTrickPlaySettings);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minFinalSegmentLength(model.minFinalSegmentLength);
            this.minSegmentLength(model.minSegmentLength);
            this.outputSelection(model.outputSelection);
            this.programDateTime(model.programDateTime);
            this.programDateTimePeriod(model.programDateTimePeriod);
            this.progressiveWriteHlsManifest(model.progressiveWriteHlsManifest);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.segmentLengthControl(model.segmentLengthControl);
            this.segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            this.streamInfResolution(model.streamInfResolution);
            this.targetDurationCompatibilityMode(model.targetDurationCompatibilityMode);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
            this.timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
        }

        public final Collection<String> getAdMarkers() {
            if (this.adMarkers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adMarkers;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
        }

        @Override
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkersWithStrings(String ... adMarkers) {
            this.adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        public final Builder adMarkers(Collection<HlsAdMarkers> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkers(HlsAdMarkers ... adMarkers) {
            this.adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final List<HlsAdditionalManifest.Builder> getAdditionalManifests() {
            List<HlsAdditionalManifest.Builder> result = ___listOfHlsAdditionalManifestCopier.copyToBuilder(this.additionalManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalManifests(Collection<HlsAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfHlsAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        @Override
        public final Builder additionalManifests(Collection<HlsAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfHlsAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(HlsAdditionalManifest ... additionalManifests) {
            this.additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<HlsAdditionalManifest.Builder> ... additionalManifests) {
            this.additionalManifests(Stream.of(additionalManifests).map(c -> (HlsAdditionalManifest)((HlsAdditionalManifest.Builder)HlsAdditionalManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAudioOnlyHeader() {
            return this.audioOnlyHeader;
        }

        public final void setAudioOnlyHeader(String audioOnlyHeader) {
            this.audioOnlyHeader = audioOnlyHeader;
        }

        @Override
        public final Builder audioOnlyHeader(String audioOnlyHeader) {
            this.audioOnlyHeader = audioOnlyHeader;
            return this;
        }

        @Override
        public final Builder audioOnlyHeader(HlsAudioOnlyHeader audioOnlyHeader) {
            this.audioOnlyHeader(audioOnlyHeader == null ? null : audioOnlyHeader.toString());
            return this;
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final List<HlsCaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            List<HlsCaptionLanguageMapping.Builder> result = ___listOfHlsCaptionLanguageMappingCopier.copyToBuilder(this.captionLanguageMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaptionLanguageMappings(Collection<HlsCaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        @Override
        public final Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(HlsCaptionLanguageMapping ... captionLanguageMappings) {
            this.captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder> ... captionLanguageMappings) {
            this.captionLanguageMappings(Stream.of(captionLanguageMappings).map(c -> (HlsCaptionLanguageMapping)((HlsCaptionLanguageMapping.Builder)HlsCaptionLanguageMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCaptionLanguageSetting() {
            return this.captionLanguageSetting;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        @Override
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting == null ? null : captionLanguageSetting.toString());
            return this;
        }

        public final String getCaptionSegmentLengthControl() {
            return this.captionSegmentLengthControl;
        }

        public final void setCaptionSegmentLengthControl(String captionSegmentLengthControl) {
            this.captionSegmentLengthControl = captionSegmentLengthControl;
        }

        @Override
        public final Builder captionSegmentLengthControl(String captionSegmentLengthControl) {
            this.captionSegmentLengthControl = captionSegmentLengthControl;
            return this;
        }

        @Override
        public final Builder captionSegmentLengthControl(HlsCaptionSegmentLengthControl captionSegmentLengthControl) {
            this.captionSegmentLengthControl(captionSegmentLengthControl == null ? null : captionSegmentLengthControl.toString());
            return this;
        }

        public final String getClientCache() {
            return this.clientCache;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final String getCodecSpecification() {
            return this.codecSpecification;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final String getDirectoryStructure() {
            return this.directoryStructure;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        @Override
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure == null ? null : directoryStructure.toString());
            return this;
        }

        public final HlsEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(HlsEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(HlsEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getImageBasedTrickPlay() {
            return this.imageBasedTrickPlay;
        }

        public final void setImageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
        }

        @Override
        public final Builder imageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
            return this;
        }

        @Override
        public final Builder imageBasedTrickPlay(HlsImageBasedTrickPlay imageBasedTrickPlay) {
            this.imageBasedTrickPlay(imageBasedTrickPlay == null ? null : imageBasedTrickPlay.toString());
            return this;
        }

        public final HlsImageBasedTrickPlaySettings.Builder getImageBasedTrickPlaySettings() {
            return this.imageBasedTrickPlaySettings != null ? this.imageBasedTrickPlaySettings.toBuilder() : null;
        }

        public final void setImageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings.BuilderImpl imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.build() : null;
        }

        @Override
        public final Builder imageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings;
            return this;
        }

        public final String getManifestCompression() {
            return this.manifestCompression;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final String getManifestDurationFormat() {
            return this.manifestDurationFormat;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final Double getMinFinalSegmentLength() {
            return this.minFinalSegmentLength;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final Integer getMinSegmentLength() {
            return this.minSegmentLength;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        @Override
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final String getOutputSelection() {
            return this.outputSelection;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        @Override
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection == null ? null : outputSelection.toString());
            return this;
        }

        public final String getProgramDateTime() {
            return this.programDateTime;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        @Override
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime == null ? null : programDateTime.toString());
            return this;
        }

        public final Integer getProgramDateTimePeriod() {
            return this.programDateTimePeriod;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        @Override
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final String getProgressiveWriteHlsManifest() {
            return this.progressiveWriteHlsManifest;
        }

        public final void setProgressiveWriteHlsManifest(String progressiveWriteHlsManifest) {
            this.progressiveWriteHlsManifest = progressiveWriteHlsManifest;
        }

        @Override
        public final Builder progressiveWriteHlsManifest(String progressiveWriteHlsManifest) {
            this.progressiveWriteHlsManifest = progressiveWriteHlsManifest;
            return this;
        }

        @Override
        public final Builder progressiveWriteHlsManifest(HlsProgressiveWriteHlsManifest progressiveWriteHlsManifest) {
            this.progressiveWriteHlsManifest(progressiveWriteHlsManifest == null ? null : progressiveWriteHlsManifest.toString());
            return this;
        }

        public final String getSegmentControl() {
            return this.segmentControl;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(HlsSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthControl() {
            return this.segmentLengthControl;
        }

        public final void setSegmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
        }

        @Override
        public final Builder segmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
            return this;
        }

        @Override
        public final Builder segmentLengthControl(HlsSegmentLengthControl segmentLengthControl) {
            this.segmentLengthControl(segmentLengthControl == null ? null : segmentLengthControl.toString());
            return this;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return this.segmentsPerSubdirectory;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        @Override
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final String getStreamInfResolution() {
            return this.streamInfResolution;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final String getTargetDurationCompatibilityMode() {
            return this.targetDurationCompatibilityMode;
        }

        public final void setTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
            return this;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(HlsTargetDurationCompatibilityMode targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode(targetDurationCompatibilityMode == null ? null : targetDurationCompatibilityMode.toString());
            return this;
        }

        public final String getTimedMetadataId3Frame() {
            return this.timedMetadataId3Frame;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame == null ? null : timedMetadataId3Frame.toString());
            return this;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return this.timestampDeltaMilliseconds;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        @Override
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsGroupSettings> {
        public Builder adMarkersWithStrings(Collection<String> var1);

        public Builder adMarkersWithStrings(String ... var1);

        public Builder adMarkers(Collection<HlsAdMarkers> var1);

        public Builder adMarkers(HlsAdMarkers ... var1);

        public Builder additionalManifests(Collection<HlsAdditionalManifest> var1);

        public Builder additionalManifests(HlsAdditionalManifest ... var1);

        public Builder additionalManifests(Consumer<HlsAdditionalManifest.Builder> ... var1);

        public Builder audioOnlyHeader(String var1);

        public Builder audioOnlyHeader(HlsAudioOnlyHeader var1);

        public Builder baseUrl(String var1);

        public Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> var1);

        public Builder captionLanguageMappings(HlsCaptionLanguageMapping ... var1);

        public Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder> ... var1);

        public Builder captionLanguageSetting(String var1);

        public Builder captionLanguageSetting(HlsCaptionLanguageSetting var1);

        public Builder captionSegmentLengthControl(String var1);

        public Builder captionSegmentLengthControl(HlsCaptionSegmentLengthControl var1);

        public Builder clientCache(String var1);

        public Builder clientCache(HlsClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(HlsCodecSpecification var1);

        public Builder destination(String var1);

        public Builder destinationSettings(DestinationSettings var1);

        default public Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((DestinationSettings)((DestinationSettings.Builder)DestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder directoryStructure(String var1);

        public Builder directoryStructure(HlsDirectoryStructure var1);

        public Builder encryption(HlsEncryptionSettings var1);

        default public Builder encryption(Consumer<HlsEncryptionSettings.Builder> encryption) {
            return this.encryption((HlsEncryptionSettings)((HlsEncryptionSettings.Builder)HlsEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder imageBasedTrickPlay(String var1);

        public Builder imageBasedTrickPlay(HlsImageBasedTrickPlay var1);

        public Builder imageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings var1);

        default public Builder imageBasedTrickPlaySettings(Consumer<HlsImageBasedTrickPlaySettings.Builder> imageBasedTrickPlaySettings) {
            return this.imageBasedTrickPlaySettings((HlsImageBasedTrickPlaySettings)((HlsImageBasedTrickPlaySettings.Builder)HlsImageBasedTrickPlaySettings.builder().applyMutation(imageBasedTrickPlaySettings)).build());
        }

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(HlsManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(HlsManifestDurationFormat var1);

        public Builder minFinalSegmentLength(Double var1);

        public Builder minSegmentLength(Integer var1);

        public Builder outputSelection(String var1);

        public Builder outputSelection(HlsOutputSelection var1);

        public Builder programDateTime(String var1);

        public Builder programDateTime(HlsProgramDateTime var1);

        public Builder programDateTimePeriod(Integer var1);

        public Builder progressiveWriteHlsManifest(String var1);

        public Builder progressiveWriteHlsManifest(HlsProgressiveWriteHlsManifest var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(HlsSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentLengthControl(String var1);

        public Builder segmentLengthControl(HlsSegmentLengthControl var1);

        public Builder segmentsPerSubdirectory(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(HlsStreamInfResolution var1);

        public Builder targetDurationCompatibilityMode(String var1);

        public Builder targetDurationCompatibilityMode(HlsTargetDurationCompatibilityMode var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);

        public Builder timestampDeltaMilliseconds(Integer var1);
    }
}

