/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264SaliencyAwareEncoding {
    DISABLED("DISABLED"),
    PREFERRED("PREFERRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264SaliencyAwareEncoding> VALUE_MAP;
    private final String value;

    private H264SaliencyAwareEncoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264SaliencyAwareEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264SaliencyAwareEncoding> knownValues() {
        EnumSet<H264SaliencyAwareEncoding> knownValues = EnumSet.allOf(H264SaliencyAwareEncoding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264SaliencyAwareEncoding.class, H264SaliencyAwareEncoding::toString);
    }
}

