/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CmafKeyProviderType {
    SPEKE("SPEKE"),
    STATIC_KEY("STATIC_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmafKeyProviderType> VALUE_MAP;
    private final String value;

    private CmafKeyProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CmafKeyProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CmafKeyProviderType> knownValues() {
        EnumSet<CmafKeyProviderType> knownValues = EnumSet.allOf(CmafKeyProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CmafKeyProviderType.class, CmafKeyProviderType::toString);
    }
}

