/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconvert.model.Job;
import software.amazon.awssdk.services.mediaconvert.model.SearchJobsRequest;
import software.amazon.awssdk.services.mediaconvert.model.SearchJobsResponse;

public class SearchJobsIterable
implements SdkIterable<SearchJobsResponse> {
    private final MediaConvertClient client;
    private final SearchJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchJobsIterable(MediaConvertClient client, SearchJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchJobsResponseFetcher();
    }

    public Iterator<SearchJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Job> jobs() {
        Function<SearchJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchJobsResponseFetcher
    implements SyncPageFetcher<SearchJobsResponse> {
        private SearchJobsResponseFetcher() {
        }

        public boolean hasNextPage(SearchJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchJobsResponse nextPage(SearchJobsResponse previousPage) {
            if (previousPage == null) {
                return SearchJobsIterable.this.client.searchJobs(SearchJobsIterable.this.firstRequest);
            }
            return SearchJobsIterable.this.client.searchJobs((SearchJobsRequest)((Object)SearchJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

