/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioTypeControl {
    FOLLOW_INPUT("FOLLOW_INPUT"),
    USE_CONFIGURED("USE_CONFIGURED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioTypeControl> VALUE_MAP;
    private final String value;

    private AudioTypeControl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioTypeControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioTypeControl> knownValues() {
        EnumSet<AudioTypeControl> knownValues = EnumSet.allOf(AudioTypeControl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioTypeControl.class, AudioTypeControl::toString);
    }
}

