/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Mpeg2FramerateConversionAlgorithm {
    DUPLICATE_DROP("DUPLICATE_DROP"),
    INTERPOLATE("INTERPOLATE"),
    FRAMEFORMER("FRAMEFORMER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Mpeg2FramerateConversionAlgorithm> VALUE_MAP;
    private final String value;

    private Mpeg2FramerateConversionAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Mpeg2FramerateConversionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Mpeg2FramerateConversionAlgorithm> knownValues() {
        EnumSet<Mpeg2FramerateConversionAlgorithm> knownValues = EnumSet.allOf(Mpeg2FramerateConversionAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Mpeg2FramerateConversionAlgorithm.class, Mpeg2FramerateConversionAlgorithm::toString);
    }
}

