/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BillingTagsSource {
    QUEUE("QUEUE"),
    PRESET("PRESET"),
    JOB_TEMPLATE("JOB_TEMPLATE"),
    JOB("JOB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BillingTagsSource> VALUE_MAP;
    private final String value;

    private BillingTagsSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingTagsSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BillingTagsSource> knownValues() {
        EnumSet<BillingTagsSource> knownValues = EnumSet.allOf(BillingTagsSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BillingTagsSource.class, BillingTagsSource::toString);
    }
}

