/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264FieldEncoding {
    PAFF("PAFF"),
    FORCE_FIELD("FORCE_FIELD"),
    MBAFF("MBAFF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264FieldEncoding> VALUE_MAP;
    private final String value;

    private H264FieldEncoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264FieldEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264FieldEncoding> knownValues() {
        EnumSet<H264FieldEncoding> knownValues = EnumSet.allOf(H264FieldEncoding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264FieldEncoding.class, H264FieldEncoding::toString);
    }
}

