/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265CodecLevel {
    AUTO("AUTO"),
    LEVEL_1("LEVEL_1"),
    LEVEL_2("LEVEL_2"),
    LEVEL_2_1("LEVEL_2_1"),
    LEVEL_3("LEVEL_3"),
    LEVEL_3_1("LEVEL_3_1"),
    LEVEL_4("LEVEL_4"),
    LEVEL_4_1("LEVEL_4_1"),
    LEVEL_5("LEVEL_5"),
    LEVEL_5_1("LEVEL_5_1"),
    LEVEL_5_2("LEVEL_5_2"),
    LEVEL_6("LEVEL_6"),
    LEVEL_6_1("LEVEL_6_1"),
    LEVEL_6_2("LEVEL_6_2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265CodecLevel> VALUE_MAP;
    private final String value;

    private H265CodecLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265CodecLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265CodecLevel> knownValues() {
        EnumSet<H265CodecLevel> knownValues = EnumSet.allOf(H265CodecLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265CodecLevel.class, H265CodecLevel::toString);
    }
}

