/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264CodecProfile {
    BASELINE("BASELINE"),
    HIGH("HIGH"),
    HIGH_10_BIT("HIGH_10BIT"),
    HIGH_422("HIGH_422"),
    HIGH_422_10_BIT("HIGH_422_10BIT"),
    MAIN("MAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264CodecProfile> VALUE_MAP;
    private final String value;

    private H264CodecProfile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264CodecProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264CodecProfile> knownValues() {
        EnumSet<H264CodecProfile> knownValues = EnumSet.allOf(H264CodecProfile.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264CodecProfile.class, H264CodecProfile::toString);
    }
}

