/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DecryptionMode {
    AES_CTR("AES_CTR"),
    AES_CBC("AES_CBC"),
    AES_GCM("AES_GCM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DecryptionMode> VALUE_MAP;
    private final String value;

    private DecryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DecryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DecryptionMode> knownValues() {
        EnumSet<DecryptionMode> knownValues = EnumSet.allOf(DecryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DecryptionMode.class, DecryptionMode::toString);
    }
}

