/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OutputGroupType {
    HLS_GROUP_SETTINGS("HLS_GROUP_SETTINGS"),
    DASH_ISO_GROUP_SETTINGS("DASH_ISO_GROUP_SETTINGS"),
    FILE_GROUP_SETTINGS("FILE_GROUP_SETTINGS"),
    MS_SMOOTH_GROUP_SETTINGS("MS_SMOOTH_GROUP_SETTINGS"),
    CMAF_GROUP_SETTINGS("CMAF_GROUP_SETTINGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OutputGroupType> VALUE_MAP;
    private final String value;

    private OutputGroupType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OutputGroupType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OutputGroupType> knownValues() {
        EnumSet<OutputGroupType> knownValues = EnumSet.allOf(OutputGroupType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OutputGroupType.class, OutputGroupType::toString);
    }
}

