/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265FramerateConversionAlgorithm {
    DUPLICATE_DROP("DUPLICATE_DROP"),
    INTERPOLATE("INTERPOLATE"),
    FRAMEFORMER("FRAMEFORMER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265FramerateConversionAlgorithm> VALUE_MAP;
    private final String value;

    private H265FramerateConversionAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265FramerateConversionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265FramerateConversionAlgorithm> knownValues() {
        EnumSet<H265FramerateConversionAlgorithm> knownValues = EnumSet.allOf(H265FramerateConversionAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265FramerateConversionAlgorithm.class, H265FramerateConversionAlgorithm::toString);
    }
}

