/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputScanType {
    AUTO("AUTO"),
    PSF("PSF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputScanType> VALUE_MAP;
    private final String value;

    private InputScanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputScanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputScanType> knownValues() {
        EnumSet<InputScanType> knownValues = EnumSet.allOf(InputScanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputScanType.class, InputScanType::toString);
    }
}

