/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NoiseReducerFilter {
    BILATERAL("BILATERAL"),
    MEAN("MEAN"),
    GAUSSIAN("GAUSSIAN"),
    LANCZOS("LANCZOS"),
    SHARPEN("SHARPEN"),
    CONSERVE("CONSERVE"),
    SPATIAL("SPATIAL"),
    TEMPORAL("TEMPORAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NoiseReducerFilter> VALUE_MAP;
    private final String value;

    private NoiseReducerFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NoiseReducerFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NoiseReducerFilter> knownValues() {
        EnumSet<NoiseReducerFilter> knownValues = EnumSet.allOf(NoiseReducerFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NoiseReducerFilter.class, NoiseReducerFilter::toString);
    }
}

