/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Ac3BitstreamMode;
import software.amazon.awssdk.services.mediaconvert.model.Ac3CodingMode;
import software.amazon.awssdk.services.mediaconvert.model.Ac3DynamicRangeCompressionLine;
import software.amazon.awssdk.services.mediaconvert.model.Ac3DynamicRangeCompressionProfile;
import software.amazon.awssdk.services.mediaconvert.model.Ac3DynamicRangeCompressionRf;
import software.amazon.awssdk.services.mediaconvert.model.Ac3LfeFilter;
import software.amazon.awssdk.services.mediaconvert.model.Ac3MetadataControl;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ac3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ac3Settings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(Ac3Settings.getter(Ac3Settings::bitrate)).setter(Ac3Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitstreamMode").getter(Ac3Settings.getter(Ac3Settings::bitstreamModeAsString)).setter(Ac3Settings.setter(Builder::bitstreamMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(Ac3Settings.getter(Ac3Settings::codingModeAsString)).setter(Ac3Settings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Dialnorm").getter(Ac3Settings.getter(Ac3Settings::dialnorm)).setter(Ac3Settings.setter(Builder::dialnorm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()}).build();
    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicRangeCompressionLine").getter(Ac3Settings.getter(Ac3Settings::dynamicRangeCompressionLineAsString)).setter(Ac3Settings.setter(Builder::dynamicRangeCompressionLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionLine").build()}).build();
    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicRangeCompressionProfile").getter(Ac3Settings.getter(Ac3Settings::dynamicRangeCompressionProfileAsString)).setter(Ac3Settings.setter(Builder::dynamicRangeCompressionProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionProfile").build()}).build();
    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_RF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicRangeCompressionRf").getter(Ac3Settings.getter(Ac3Settings::dynamicRangeCompressionRfAsString)).setter(Ac3Settings.setter(Builder::dynamicRangeCompressionRf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionRf").build()}).build();
    private static final SdkField<String> LFE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LfeFilter").getter(Ac3Settings.getter(Ac3Settings::lfeFilterAsString)).setter(Ac3Settings.setter(Builder::lfeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeFilter").build()}).build();
    private static final SdkField<String> METADATA_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataControl").getter(Ac3Settings.getter(Ac3Settings::metadataControlAsString)).setter(Ac3Settings.setter(Builder::metadataControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataControl").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(Ac3Settings.getter(Ac3Settings::sampleRate)).setter(Ac3Settings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DIALNORM_FIELD, DYNAMIC_RANGE_COMPRESSION_LINE_FIELD, DYNAMIC_RANGE_COMPRESSION_PROFILE_FIELD, DYNAMIC_RANGE_COMPRESSION_RF_FIELD, LFE_FILTER_FIELD, METADATA_CONTROL_FIELD, SAMPLE_RATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bitrate;
    private final String bitstreamMode;
    private final String codingMode;
    private final Integer dialnorm;
    private final String dynamicRangeCompressionLine;
    private final String dynamicRangeCompressionProfile;
    private final String dynamicRangeCompressionRf;
    private final String lfeFilter;
    private final String metadataControl;
    private final Integer sampleRate;

    private Ac3Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialnorm = builder.dialnorm;
        this.dynamicRangeCompressionLine = builder.dynamicRangeCompressionLine;
        this.dynamicRangeCompressionProfile = builder.dynamicRangeCompressionProfile;
        this.dynamicRangeCompressionRf = builder.dynamicRangeCompressionRf;
        this.lfeFilter = builder.lfeFilter;
        this.metadataControl = builder.metadataControl;
        this.sampleRate = builder.sampleRate;
    }

    public final Integer bitrate() {
        return this.bitrate;
    }

    public final Ac3BitstreamMode bitstreamMode() {
        return Ac3BitstreamMode.fromValue(this.bitstreamMode);
    }

    public final String bitstreamModeAsString() {
        return this.bitstreamMode;
    }

    public final Ac3CodingMode codingMode() {
        return Ac3CodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final Integer dialnorm() {
        return this.dialnorm;
    }

    public final Ac3DynamicRangeCompressionLine dynamicRangeCompressionLine() {
        return Ac3DynamicRangeCompressionLine.fromValue(this.dynamicRangeCompressionLine);
    }

    public final String dynamicRangeCompressionLineAsString() {
        return this.dynamicRangeCompressionLine;
    }

    public final Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile() {
        return Ac3DynamicRangeCompressionProfile.fromValue(this.dynamicRangeCompressionProfile);
    }

    public final String dynamicRangeCompressionProfileAsString() {
        return this.dynamicRangeCompressionProfile;
    }

    public final Ac3DynamicRangeCompressionRf dynamicRangeCompressionRf() {
        return Ac3DynamicRangeCompressionRf.fromValue(this.dynamicRangeCompressionRf);
    }

    public final String dynamicRangeCompressionRfAsString() {
        return this.dynamicRangeCompressionRf;
    }

    public final Ac3LfeFilter lfeFilter() {
        return Ac3LfeFilter.fromValue(this.lfeFilter);
    }

    public final String lfeFilterAsString() {
        return this.lfeFilter;
    }

    public final Ac3MetadataControl metadataControl() {
        return Ac3MetadataControl.fromValue(this.metadataControl);
    }

    public final String metadataControlAsString() {
        return this.metadataControl;
    }

    public final Integer sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeCompressionLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeCompressionProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeCompressionRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ac3Settings)) {
            return false;
        }
        Ac3Settings other = (Ac3Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bitstreamModeAsString(), other.bitstreamModeAsString()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.dialnorm(), other.dialnorm()) && Objects.equals(this.dynamicRangeCompressionLineAsString(), other.dynamicRangeCompressionLineAsString()) && Objects.equals(this.dynamicRangeCompressionProfileAsString(), other.dynamicRangeCompressionProfileAsString()) && Objects.equals(this.dynamicRangeCompressionRfAsString(), other.dynamicRangeCompressionRfAsString()) && Objects.equals(this.lfeFilterAsString(), other.lfeFilterAsString()) && Objects.equals(this.metadataControlAsString(), other.metadataControlAsString()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public final String toString() {
        return ToString.builder((String)"Ac3Settings").add("Bitrate", (Object)this.bitrate()).add("BitstreamMode", (Object)this.bitstreamModeAsString()).add("CodingMode", (Object)this.codingModeAsString()).add("Dialnorm", (Object)this.dialnorm()).add("DynamicRangeCompressionLine", (Object)this.dynamicRangeCompressionLineAsString()).add("DynamicRangeCompressionProfile", (Object)this.dynamicRangeCompressionProfileAsString()).add("DynamicRangeCompressionRf", (Object)this.dynamicRangeCompressionRfAsString()).add("LfeFilter", (Object)this.lfeFilterAsString()).add("MetadataControl", (Object)this.metadataControlAsString()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BitstreamMode": {
                return Optional.ofNullable(clazz.cast(this.bitstreamModeAsString()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "Dialnorm": {
                return Optional.ofNullable(clazz.cast(this.dialnorm()));
            }
            case "DynamicRangeCompressionLine": {
                return Optional.ofNullable(clazz.cast(this.dynamicRangeCompressionLineAsString()));
            }
            case "DynamicRangeCompressionProfile": {
                return Optional.ofNullable(clazz.cast(this.dynamicRangeCompressionProfileAsString()));
            }
            case "DynamicRangeCompressionRf": {
                return Optional.ofNullable(clazz.cast(this.dynamicRangeCompressionRfAsString()));
            }
            case "LfeFilter": {
                return Optional.ofNullable(clazz.cast(this.lfeFilterAsString()));
            }
            case "MetadataControl": {
                return Optional.ofNullable(clazz.cast(this.metadataControlAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ac3Settings, T> g) {
        return obj -> g.apply((Ac3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitrate;
        private String bitstreamMode;
        private String codingMode;
        private Integer dialnorm;
        private String dynamicRangeCompressionLine;
        private String dynamicRangeCompressionProfile;
        private String dynamicRangeCompressionRf;
        private String lfeFilter;
        private String metadataControl;
        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(Ac3Settings model) {
            this.bitrate(model.bitrate);
            this.bitstreamMode(model.bitstreamMode);
            this.codingMode(model.codingMode);
            this.dialnorm(model.dialnorm);
            this.dynamicRangeCompressionLine(model.dynamicRangeCompressionLine);
            this.dynamicRangeCompressionProfile(model.dynamicRangeCompressionProfile);
            this.dynamicRangeCompressionRf(model.dynamicRangeCompressionRf);
            this.lfeFilter(model.lfeFilter);
            this.metadataControl(model.metadataControl);
            this.sampleRate(model.sampleRate);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        @Transient
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getBitstreamMode() {
            return this.bitstreamMode;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        @Override
        @Transient
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        @Transient
        public final Builder bitstreamMode(Ac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        @Transient
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder codingMode(Ac3CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final Integer getDialnorm() {
            return this.dialnorm;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        @Override
        @Transient
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final String getDynamicRangeCompressionLine() {
            return this.dynamicRangeCompressionLine;
        }

        public final void setDynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
            return this;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionLine(Ac3DynamicRangeCompressionLine dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine(dynamicRangeCompressionLine == null ? null : dynamicRangeCompressionLine.toString());
            return this;
        }

        public final String getDynamicRangeCompressionProfile() {
            return this.dynamicRangeCompressionProfile;
        }

        public final void setDynamicRangeCompressionProfile(String dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile = dynamicRangeCompressionProfile;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionProfile(String dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile = dynamicRangeCompressionProfile;
            return this;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionProfile(Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile(dynamicRangeCompressionProfile == null ? null : dynamicRangeCompressionProfile.toString());
            return this;
        }

        public final String getDynamicRangeCompressionRf() {
            return this.dynamicRangeCompressionRf;
        }

        public final void setDynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
            return this;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionRf(Ac3DynamicRangeCompressionRf dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf(dynamicRangeCompressionRf == null ? null : dynamicRangeCompressionRf.toString());
            return this;
        }

        public final String getLfeFilter() {
            return this.lfeFilter;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        @Override
        @Transient
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder lfeFilter(Ac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter == null ? null : lfeFilter.toString());
            return this;
        }

        public final String getMetadataControl() {
            return this.metadataControl;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        @Override
        @Transient
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        @Transient
        public final Builder metadataControl(Ac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl == null ? null : metadataControl.toString());
            return this;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        @Transient
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Ac3Settings build() {
            return new Ac3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ac3Settings> {
        public Builder bitrate(Integer var1);

        public Builder bitstreamMode(String var1);

        public Builder bitstreamMode(Ac3BitstreamMode var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Ac3CodingMode var1);

        public Builder dialnorm(Integer var1);

        public Builder dynamicRangeCompressionLine(String var1);

        public Builder dynamicRangeCompressionLine(Ac3DynamicRangeCompressionLine var1);

        public Builder dynamicRangeCompressionProfile(String var1);

        public Builder dynamicRangeCompressionProfile(Ac3DynamicRangeCompressionProfile var1);

        public Builder dynamicRangeCompressionRf(String var1);

        public Builder dynamicRangeCompressionRf(Ac3DynamicRangeCompressionRf var1);

        public Builder lfeFilter(String var1);

        public Builder lfeFilter(Ac3LfeFilter var1);

        public Builder metadataControl(String var1);

        public Builder metadataControl(Ac3MetadataControl var1);

        public Builder sampleRate(Integer var1);
    }
}

