/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum H264SceneChangeDetect {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    TRANSITION_DETECTION("TRANSITION_DETECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H264SceneChangeDetect(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264SceneChangeDetect fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H264SceneChangeDetect.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264SceneChangeDetect> knownValues() {
        return Stream.of(H264SceneChangeDetect.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

