/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AudioChannelTag {
    L("L"),
    R("R"),
    C("C"),
    LFE("LFE"),
    LS("LS"),
    RS("RS"),
    LC("LC"),
    RC("RC"),
    CS("CS"),
    LSD("LSD"),
    RSD("RSD"),
    TCS("TCS"),
    VHL("VHL"),
    VHC("VHC"),
    VHR("VHR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AudioChannelTag(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioChannelTag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AudioChannelTag.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioChannelTag> knownValues() {
        return Stream.of(AudioChannelTag.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

