/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AvailBlanking;
import software.amazon.awssdk.services.mediaconvert.model.EsamSettings;
import software.amazon.awssdk.services.mediaconvert.model.InputTemplate;
import software.amazon.awssdk.services.mediaconvert.model.MotionImageInserter;
import software.amazon.awssdk.services.mediaconvert.model.NielsenConfiguration;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroup;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeConfig;
import software.amazon.awssdk.services.mediaconvert.model.TimedMetadataInsertion;
import software.amazon.awssdk.services.mediaconvert.model.___listOfInputTemplateCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfOutputGroupCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobTemplateSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobTemplateSettings> {
    private static final SdkField<Integer> AD_AVAIL_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobTemplateSettings.getter(JobTemplateSettings::adAvailOffset)).setter(JobTemplateSettings.setter(Builder::adAvailOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adAvailOffset").build()}).build();
    private static final SdkField<AvailBlanking> AVAIL_BLANKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplateSettings.getter(JobTemplateSettings::availBlanking)).setter(JobTemplateSettings.setter(Builder::availBlanking)).constructor(AvailBlanking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlanking").build()}).build();
    private static final SdkField<EsamSettings> ESAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplateSettings.getter(JobTemplateSettings::esam)).setter(JobTemplateSettings.setter(Builder::esam)).constructor(EsamSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esam").build()}).build();
    private static final SdkField<List<InputTemplate>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(JobTemplateSettings.getter(JobTemplateSettings::inputs)).setter(JobTemplateSettings.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MotionImageInserter> MOTION_IMAGE_INSERTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplateSettings.getter(JobTemplateSettings::motionImageInserter)).setter(JobTemplateSettings.setter(Builder::motionImageInserter)).constructor(MotionImageInserter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("motionImageInserter").build()}).build();
    private static final SdkField<NielsenConfiguration> NIELSEN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplateSettings.getter(JobTemplateSettings::nielsenConfiguration)).setter(JobTemplateSettings.setter(Builder::nielsenConfiguration)).constructor(NielsenConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenConfiguration").build()}).build();
    private static final SdkField<List<OutputGroup>> OUTPUT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(JobTemplateSettings.getter(JobTemplateSettings::outputGroups)).setter(JobTemplateSettings.setter(Builder::outputGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimecodeConfig> TIMECODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplateSettings.getter(JobTemplateSettings::timecodeConfig)).setter(JobTemplateSettings.setter(Builder::timecodeConfig)).constructor(TimecodeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeConfig").build()}).build();
    private static final SdkField<TimedMetadataInsertion> TIMED_METADATA_INSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplateSettings.getter(JobTemplateSettings::timedMetadataInsertion)).setter(JobTemplateSettings.setter(Builder::timedMetadataInsertion)).constructor(TimedMetadataInsertion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataInsertion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_AVAIL_OFFSET_FIELD, AVAIL_BLANKING_FIELD, ESAM_FIELD, INPUTS_FIELD, MOTION_IMAGE_INSERTER_FIELD, NIELSEN_CONFIGURATION_FIELD, OUTPUT_GROUPS_FIELD, TIMECODE_CONFIG_FIELD, TIMED_METADATA_INSERTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer adAvailOffset;
    private final AvailBlanking availBlanking;
    private final EsamSettings esam;
    private final List<InputTemplate> inputs;
    private final MotionImageInserter motionImageInserter;
    private final NielsenConfiguration nielsenConfiguration;
    private final List<OutputGroup> outputGroups;
    private final TimecodeConfig timecodeConfig;
    private final TimedMetadataInsertion timedMetadataInsertion;

    private JobTemplateSettings(BuilderImpl builder) {
        this.adAvailOffset = builder.adAvailOffset;
        this.availBlanking = builder.availBlanking;
        this.esam = builder.esam;
        this.inputs = builder.inputs;
        this.motionImageInserter = builder.motionImageInserter;
        this.nielsenConfiguration = builder.nielsenConfiguration;
        this.outputGroups = builder.outputGroups;
        this.timecodeConfig = builder.timecodeConfig;
        this.timedMetadataInsertion = builder.timedMetadataInsertion;
    }

    public Integer adAvailOffset() {
        return this.adAvailOffset;
    }

    public AvailBlanking availBlanking() {
        return this.availBlanking;
    }

    public EsamSettings esam() {
        return this.esam;
    }

    public boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public List<InputTemplate> inputs() {
        return this.inputs;
    }

    public MotionImageInserter motionImageInserter() {
        return this.motionImageInserter;
    }

    public NielsenConfiguration nielsenConfiguration() {
        return this.nielsenConfiguration;
    }

    public boolean hasOutputGroups() {
        return this.outputGroups != null && !(this.outputGroups instanceof SdkAutoConstructList);
    }

    public List<OutputGroup> outputGroups() {
        return this.outputGroups;
    }

    public TimecodeConfig timecodeConfig() {
        return this.timecodeConfig;
    }

    public TimedMetadataInsertion timedMetadataInsertion() {
        return this.timedMetadataInsertion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adAvailOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.availBlanking());
        hashCode = 31 * hashCode + Objects.hashCode(this.esam());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.motionImageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataInsertion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplateSettings)) {
            return false;
        }
        JobTemplateSettings other = (JobTemplateSettings)obj;
        return Objects.equals(this.adAvailOffset(), other.adAvailOffset()) && Objects.equals(this.availBlanking(), other.availBlanking()) && Objects.equals(this.esam(), other.esam()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.motionImageInserter(), other.motionImageInserter()) && Objects.equals(this.nielsenConfiguration(), other.nielsenConfiguration()) && Objects.equals(this.outputGroups(), other.outputGroups()) && Objects.equals(this.timecodeConfig(), other.timecodeConfig()) && Objects.equals(this.timedMetadataInsertion(), other.timedMetadataInsertion());
    }

    public String toString() {
        return ToString.builder((String)"JobTemplateSettings").add("AdAvailOffset", (Object)this.adAvailOffset()).add("AvailBlanking", (Object)this.availBlanking()).add("Esam", (Object)this.esam()).add("Inputs", this.inputs()).add("MotionImageInserter", (Object)this.motionImageInserter()).add("NielsenConfiguration", (Object)this.nielsenConfiguration()).add("OutputGroups", this.outputGroups()).add("TimecodeConfig", (Object)this.timecodeConfig()).add("TimedMetadataInsertion", (Object)this.timedMetadataInsertion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdAvailOffset": {
                return Optional.ofNullable(clazz.cast(this.adAvailOffset()));
            }
            case "AvailBlanking": {
                return Optional.ofNullable(clazz.cast(this.availBlanking()));
            }
            case "Esam": {
                return Optional.ofNullable(clazz.cast(this.esam()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "MotionImageInserter": {
                return Optional.ofNullable(clazz.cast(this.motionImageInserter()));
            }
            case "NielsenConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nielsenConfiguration()));
            }
            case "OutputGroups": {
                return Optional.ofNullable(clazz.cast(this.outputGroups()));
            }
            case "TimecodeConfig": {
                return Optional.ofNullable(clazz.cast(this.timecodeConfig()));
            }
            case "TimedMetadataInsertion": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataInsertion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTemplateSettings, T> g) {
        return obj -> g.apply((JobTemplateSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer adAvailOffset;
        private AvailBlanking availBlanking;
        private EsamSettings esam;
        private List<InputTemplate> inputs = DefaultSdkAutoConstructList.getInstance();
        private MotionImageInserter motionImageInserter;
        private NielsenConfiguration nielsenConfiguration;
        private List<OutputGroup> outputGroups = DefaultSdkAutoConstructList.getInstance();
        private TimecodeConfig timecodeConfig;
        private TimedMetadataInsertion timedMetadataInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplateSettings model) {
            this.adAvailOffset(model.adAvailOffset);
            this.availBlanking(model.availBlanking);
            this.esam(model.esam);
            this.inputs(model.inputs);
            this.motionImageInserter(model.motionImageInserter);
            this.nielsenConfiguration(model.nielsenConfiguration);
            this.outputGroups(model.outputGroups);
            this.timecodeConfig(model.timecodeConfig);
            this.timedMetadataInsertion(model.timedMetadataInsertion);
        }

        public final Integer getAdAvailOffset() {
            return this.adAvailOffset;
        }

        @Override
        public final Builder adAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
            return this;
        }

        public final void setAdAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
        }

        public final AvailBlanking.Builder getAvailBlanking() {
            return this.availBlanking != null ? this.availBlanking.toBuilder() : null;
        }

        @Override
        public final Builder availBlanking(AvailBlanking availBlanking) {
            this.availBlanking = availBlanking;
            return this;
        }

        public final void setAvailBlanking(AvailBlanking.BuilderImpl availBlanking) {
            this.availBlanking = availBlanking != null ? availBlanking.build() : null;
        }

        public final EsamSettings.Builder getEsam() {
            return this.esam != null ? this.esam.toBuilder() : null;
        }

        @Override
        public final Builder esam(EsamSettings esam) {
            this.esam = esam;
            return this;
        }

        public final void setEsam(EsamSettings.BuilderImpl esam) {
            this.esam = esam != null ? esam.build() : null;
        }

        public final Collection<InputTemplate.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(InputTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<InputTemplate> inputs) {
            this.inputs = ___listOfInputTemplateCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(InputTemplate ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<InputTemplate.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (InputTemplate)((InputTemplate.Builder)InputTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputs(Collection<InputTemplate.BuilderImpl> inputs) {
            this.inputs = ___listOfInputTemplateCopier.copyFromBuilder(inputs);
        }

        public final MotionImageInserter.Builder getMotionImageInserter() {
            return this.motionImageInserter != null ? this.motionImageInserter.toBuilder() : null;
        }

        @Override
        public final Builder motionImageInserter(MotionImageInserter motionImageInserter) {
            this.motionImageInserter = motionImageInserter;
            return this;
        }

        public final void setMotionImageInserter(MotionImageInserter.BuilderImpl motionImageInserter) {
            this.motionImageInserter = motionImageInserter != null ? motionImageInserter.build() : null;
        }

        public final NielsenConfiguration.Builder getNielsenConfiguration() {
            return this.nielsenConfiguration != null ? this.nielsenConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration;
            return this;
        }

        public final void setNielsenConfiguration(NielsenConfiguration.BuilderImpl nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration != null ? nielsenConfiguration.build() : null;
        }

        public final Collection<OutputGroup.Builder> getOutputGroups() {
            return this.outputGroups != null ? (Collection)this.outputGroups.stream().map(OutputGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputGroups(Collection<OutputGroup> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copy(outputGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(OutputGroup ... outputGroups) {
            this.outputGroups(Arrays.asList(outputGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(Consumer<OutputGroup.Builder> ... outputGroups) {
            this.outputGroups(Stream.of(outputGroups).map(c -> (OutputGroup)((OutputGroup.Builder)OutputGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputGroups(Collection<OutputGroup.BuilderImpl> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copyFromBuilder(outputGroups);
        }

        public final TimecodeConfig.Builder getTimecodeConfig() {
            return this.timecodeConfig != null ? this.timecodeConfig.toBuilder() : null;
        }

        @Override
        public final Builder timecodeConfig(TimecodeConfig timecodeConfig) {
            this.timecodeConfig = timecodeConfig;
            return this;
        }

        public final void setTimecodeConfig(TimecodeConfig.BuilderImpl timecodeConfig) {
            this.timecodeConfig = timecodeConfig != null ? timecodeConfig.build() : null;
        }

        public final TimedMetadataInsertion.Builder getTimedMetadataInsertion() {
            return this.timedMetadataInsertion != null ? this.timedMetadataInsertion.toBuilder() : null;
        }

        @Override
        public final Builder timedMetadataInsertion(TimedMetadataInsertion timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion;
            return this;
        }

        public final void setTimedMetadataInsertion(TimedMetadataInsertion.BuilderImpl timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion != null ? timedMetadataInsertion.build() : null;
        }

        public JobTemplateSettings build() {
            return new JobTemplateSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobTemplateSettings> {
        public Builder adAvailOffset(Integer var1);

        public Builder availBlanking(AvailBlanking var1);

        default public Builder availBlanking(Consumer<AvailBlanking.Builder> availBlanking) {
            return this.availBlanking((AvailBlanking)((AvailBlanking.Builder)AvailBlanking.builder().applyMutation(availBlanking)).build());
        }

        public Builder esam(EsamSettings var1);

        default public Builder esam(Consumer<EsamSettings.Builder> esam) {
            return this.esam((EsamSettings)((EsamSettings.Builder)EsamSettings.builder().applyMutation(esam)).build());
        }

        public Builder inputs(Collection<InputTemplate> var1);

        public Builder inputs(InputTemplate ... var1);

        public Builder inputs(Consumer<InputTemplate.Builder> ... var1);

        public Builder motionImageInserter(MotionImageInserter var1);

        default public Builder motionImageInserter(Consumer<MotionImageInserter.Builder> motionImageInserter) {
            return this.motionImageInserter((MotionImageInserter)((MotionImageInserter.Builder)MotionImageInserter.builder().applyMutation(motionImageInserter)).build());
        }

        public Builder nielsenConfiguration(NielsenConfiguration var1);

        default public Builder nielsenConfiguration(Consumer<NielsenConfiguration.Builder> nielsenConfiguration) {
            return this.nielsenConfiguration((NielsenConfiguration)((NielsenConfiguration.Builder)NielsenConfiguration.builder().applyMutation(nielsenConfiguration)).build());
        }

        public Builder outputGroups(Collection<OutputGroup> var1);

        public Builder outputGroups(OutputGroup ... var1);

        public Builder outputGroups(Consumer<OutputGroup.Builder> ... var1);

        public Builder timecodeConfig(TimecodeConfig var1);

        default public Builder timecodeConfig(Consumer<TimecodeConfig.Builder> timecodeConfig) {
            return this.timecodeConfig((TimecodeConfig)((TimecodeConfig.Builder)TimecodeConfig.builder().applyMutation(timecodeConfig)).build());
        }

        public Builder timedMetadataInsertion(TimedMetadataInsertion var1);

        default public Builder timedMetadataInsertion(Consumer<TimedMetadataInsertion.Builder> timedMetadataInsertion) {
            return this.timedMetadataInsertion((TimedMetadataInsertion)((TimedMetadataInsertion.Builder)TimedMetadataInsertion.builder().applyMutation(timedMetadataInsertion)).build());
        }
    }
}

