/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Commitment;
import software.amazon.awssdk.services.mediaconvert.model.RenewalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationPlanSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationPlanSettings> {
    private static final SdkField<String> COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationPlanSettings.getter(ReservationPlanSettings::commitmentAsString)).setter(ReservationPlanSettings.setter(Builder::commitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()}).build();
    private static final SdkField<String> RENEWAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationPlanSettings.getter(ReservationPlanSettings::renewalTypeAsString)).setter(ReservationPlanSettings.setter(Builder::renewalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalType").build()}).build();
    private static final SdkField<Integer> RESERVED_SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReservationPlanSettings.getter(ReservationPlanSettings::reservedSlots)).setter(ReservationPlanSettings.setter(Builder::reservedSlots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedSlots").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMITMENT_FIELD, RENEWAL_TYPE_FIELD, RESERVED_SLOTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String commitment;
    private final String renewalType;
    private final Integer reservedSlots;

    private ReservationPlanSettings(BuilderImpl builder) {
        this.commitment = builder.commitment;
        this.renewalType = builder.renewalType;
        this.reservedSlots = builder.reservedSlots;
    }

    public Commitment commitment() {
        return Commitment.fromValue(this.commitment);
    }

    public String commitmentAsString() {
        return this.commitment;
    }

    public RenewalType renewalType() {
        return RenewalType.fromValue(this.renewalType);
    }

    public String renewalTypeAsString() {
        return this.renewalType;
    }

    public Integer reservedSlots() {
        return this.reservedSlots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedSlots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPlanSettings)) {
            return false;
        }
        ReservationPlanSettings other = (ReservationPlanSettings)obj;
        return Objects.equals(this.commitmentAsString(), other.commitmentAsString()) && Objects.equals(this.renewalTypeAsString(), other.renewalTypeAsString()) && Objects.equals(this.reservedSlots(), other.reservedSlots());
    }

    public String toString() {
        return ToString.builder((String)"ReservationPlanSettings").add("Commitment", (Object)this.commitmentAsString()).add("RenewalType", (Object)this.renewalTypeAsString()).add("ReservedSlots", (Object)this.reservedSlots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Commitment": {
                return Optional.ofNullable(clazz.cast(this.commitmentAsString()));
            }
            case "RenewalType": {
                return Optional.ofNullable(clazz.cast(this.renewalTypeAsString()));
            }
            case "ReservedSlots": {
                return Optional.ofNullable(clazz.cast(this.reservedSlots()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationPlanSettings, T> g) {
        return obj -> g.apply((ReservationPlanSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commitment;
        private String renewalType;
        private Integer reservedSlots;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPlanSettings model) {
            this.commitment(model.commitment);
            this.renewalType(model.renewalType);
            this.reservedSlots(model.reservedSlots);
        }

        public final String getCommitmentAsString() {
            return this.commitment;
        }

        @Override
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        @Override
        public final Builder commitment(Commitment commitment) {
            this.commitment(commitment == null ? null : commitment.toString());
            return this;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        public final String getRenewalTypeAsString() {
            return this.renewalType;
        }

        @Override
        public final Builder renewalType(String renewalType) {
            this.renewalType = renewalType;
            return this;
        }

        @Override
        public final Builder renewalType(RenewalType renewalType) {
            this.renewalType(renewalType == null ? null : renewalType.toString());
            return this;
        }

        public final void setRenewalType(String renewalType) {
            this.renewalType = renewalType;
        }

        public final Integer getReservedSlots() {
            return this.reservedSlots;
        }

        @Override
        public final Builder reservedSlots(Integer reservedSlots) {
            this.reservedSlots = reservedSlots;
            return this;
        }

        public final void setReservedSlots(Integer reservedSlots) {
            this.reservedSlots = reservedSlots;
        }

        public ReservationPlanSettings build() {
            return new ReservationPlanSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationPlanSettings> {
        public Builder commitment(String var1);

        public Builder commitment(Commitment var1);

        public Builder renewalType(String var1);

        public Builder renewalType(RenewalType var1);

        public Builder reservedSlots(Integer var1);
    }
}

