/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.ListedFlow;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.___listOfListedFlowCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowsResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, ListFlowsResponse> {
    private static final SdkField<List<ListedFlow>> FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListFlowsResponse.getter(ListFlowsResponse::flows)).setter(ListFlowsResponse.setter(Builder::flows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedFlow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFlowsResponse.getter(ListFlowsResponse::nextToken)).setter(ListFlowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOWS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ListedFlow> flows;
    private final String nextToken;

    private ListFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.flows = builder.flows;
        this.nextToken = builder.nextToken;
    }

    public List<ListedFlow> flows() {
        return this.flows;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flows());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowsResponse)) {
            return false;
        }
        ListFlowsResponse other = (ListFlowsResponse)((Object)obj);
        return Objects.equals(this.flows(), other.flows()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFlowsResponse").add("Flows", this.flows()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Flows": {
                return Optional.ofNullable(clazz.cast(this.flows()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFlowsResponse, T> g) {
        return obj -> g.apply((ListFlowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<ListedFlow> flows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowsResponse model) {
            super(model);
            this.flows(model.flows);
            this.nextToken(model.nextToken);
        }

        public final Collection<ListedFlow.Builder> getFlows() {
            return this.flows != null ? (Collection)this.flows.stream().map(ListedFlow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder flows(Collection<ListedFlow> flows) {
            this.flows = ___listOfListedFlowCopier.copy(flows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(ListedFlow ... flows) {
            this.flows(Arrays.asList(flows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(Consumer<ListedFlow.Builder> ... flows) {
            this.flows(Stream.of(flows).map(c -> (ListedFlow)((ListedFlow.Builder)ListedFlow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFlows(Collection<ListedFlow.BuilderImpl> flows) {
            this.flows = ___listOfListedFlowCopier.copyFromBuilder(flows);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFlowsResponse build() {
            return new ListFlowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowsResponse> {
        public Builder flows(Collection<ListedFlow> var1);

        public Builder flows(ListedFlow ... var1);

        public Builder flows(Consumer<ListedFlow.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

