/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedEntitlement;

public class ListEntitlementsIterable
implements SdkIterable<ListEntitlementsResponse> {
    private final MediaConnectClient client;
    private final ListEntitlementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntitlementsIterable(MediaConnectClient client, ListEntitlementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEntitlementsResponseFetcher();
    }

    public Iterator<ListEntitlementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedEntitlement> entitlements() {
        Function<ListEntitlementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entitlements() != null) {
                return response.entitlements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEntitlementsResponseFetcher
    implements SyncPageFetcher<ListEntitlementsResponse> {
        private ListEntitlementsResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitlementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntitlementsResponse nextPage(ListEntitlementsResponse previousPage) {
            if (previousPage == null) {
                return ListEntitlementsIterable.this.client.listEntitlements(ListEntitlementsIterable.this.firstRequest);
            }
            return ListEntitlementsIterable.this.client.listEntitlements((ListEntitlementsRequest)((Object)ListEntitlementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

