/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Algorithm;
import software.amazon.awssdk.services.mediaconnect.model.KeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateEncryption> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEncryption.getter(UpdateEncryption::algorithmAsString)).setter(UpdateEncryption.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEncryption.getter(UpdateEncryption::keyTypeAsString)).setter(UpdateEncryption.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEncryption.getter(UpdateEncryption::roleArn)).setter(UpdateEncryption.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEncryption.getter(UpdateEncryption::secretArn)).setter(UpdateEncryption.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, KEY_TYPE_FIELD, ROLE_ARN_FIELD, SECRET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String keyType;
    private final String roleArn;
    private final String secretArn;

    private UpdateEncryption(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.keyType = builder.keyType;
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
    }

    public Algorithm algorithm() {
        return Algorithm.fromValue(this.algorithm);
    }

    public String algorithmAsString() {
        return this.algorithm;
    }

    public KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public String keyTypeAsString() {
        return this.keyType;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEncryption)) {
            return false;
        }
        UpdateEncryption other = (UpdateEncryption)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEncryption").add("Algorithm", (Object)this.algorithmAsString()).add("KeyType", (Object)this.keyTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEncryption, T> g) {
        return obj -> g.apply((UpdateEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String keyType;
        private String roleArn;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEncryption model) {
            this.algorithm(model.algorithm);
            this.keyType(model.keyType);
            this.roleArn(model.roleArn);
            this.secretArn(model.secretArn);
        }

        public final String getAlgorithmAsString() {
            return this.algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getKeyTypeAsString() {
            return this.keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public UpdateEncryption build() {
            return new UpdateEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateEncryption> {
        public Builder algorithm(String var1);

        public Builder algorithm(Algorithm var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);

        public Builder roleArn(String var1);

        public Builder secretArn(String var1);
    }
}

