/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.NdiDiscoveryServerConfig;
import software.amazon.awssdk.services.mediaconnect.model.NdiState;
import software.amazon.awssdk.services.mediaconnect.model.___listOfNdiDiscoveryServerConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NdiConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NdiConfig> {
    private static final SdkField<String> NDI_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NdiState").getter(NdiConfig.getter(NdiConfig::ndiStateAsString)).setter(NdiConfig.setter(Builder::ndiState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiState").build()}).build();
    private static final SdkField<String> MACHINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MachineName").getter(NdiConfig.getter(NdiConfig::machineName)).setter(NdiConfig.setter(Builder::machineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("machineName").build()}).build();
    private static final SdkField<List<NdiDiscoveryServerConfig>> NDI_DISCOVERY_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NdiDiscoveryServers").getter(NdiConfig.getter(NdiConfig::ndiDiscoveryServers)).setter(NdiConfig.setter(Builder::ndiDiscoveryServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiDiscoveryServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NdiDiscoveryServerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NDI_STATE_FIELD, MACHINE_NAME_FIELD, NDI_DISCOVERY_SERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NdiConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ndiState;
    private final String machineName;
    private final List<NdiDiscoveryServerConfig> ndiDiscoveryServers;

    private NdiConfig(BuilderImpl builder) {
        this.ndiState = builder.ndiState;
        this.machineName = builder.machineName;
        this.ndiDiscoveryServers = builder.ndiDiscoveryServers;
    }

    public final NdiState ndiState() {
        return NdiState.fromValue(this.ndiState);
    }

    public final String ndiStateAsString() {
        return this.ndiState;
    }

    public final String machineName() {
        return this.machineName;
    }

    public final boolean hasNdiDiscoveryServers() {
        return this.ndiDiscoveryServers != null && !(this.ndiDiscoveryServers instanceof SdkAutoConstructList);
    }

    public final List<NdiDiscoveryServerConfig> ndiDiscoveryServers() {
        return this.ndiDiscoveryServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ndiStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.machineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNdiDiscoveryServers() ? this.ndiDiscoveryServers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NdiConfig)) {
            return false;
        }
        NdiConfig other = (NdiConfig)obj;
        return Objects.equals(this.ndiStateAsString(), other.ndiStateAsString()) && Objects.equals(this.machineName(), other.machineName()) && this.hasNdiDiscoveryServers() == other.hasNdiDiscoveryServers() && Objects.equals(this.ndiDiscoveryServers(), other.ndiDiscoveryServers());
    }

    public final String toString() {
        return ToString.builder((String)"NdiConfig").add("NdiState", (Object)this.ndiStateAsString()).add("MachineName", (Object)this.machineName()).add("NdiDiscoveryServers", this.hasNdiDiscoveryServers() ? this.ndiDiscoveryServers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NdiState": {
                return Optional.ofNullable(clazz.cast(this.ndiStateAsString()));
            }
            case "MachineName": {
                return Optional.ofNullable(clazz.cast(this.machineName()));
            }
            case "NdiDiscoveryServers": {
                return Optional.ofNullable(clazz.cast(this.ndiDiscoveryServers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ndiState", NDI_STATE_FIELD);
        map.put("machineName", MACHINE_NAME_FIELD);
        map.put("ndiDiscoveryServers", NDI_DISCOVERY_SERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NdiConfig, T> g) {
        return obj -> g.apply((NdiConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ndiState;
        private String machineName;
        private List<NdiDiscoveryServerConfig> ndiDiscoveryServers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NdiConfig model) {
            this.ndiState(model.ndiState);
            this.machineName(model.machineName);
            this.ndiDiscoveryServers(model.ndiDiscoveryServers);
        }

        public final String getNdiState() {
            return this.ndiState;
        }

        public final void setNdiState(String ndiState) {
            this.ndiState = ndiState;
        }

        @Override
        public final Builder ndiState(String ndiState) {
            this.ndiState = ndiState;
            return this;
        }

        @Override
        public final Builder ndiState(NdiState ndiState) {
            this.ndiState(ndiState == null ? null : ndiState.toString());
            return this;
        }

        public final String getMachineName() {
            return this.machineName;
        }

        public final void setMachineName(String machineName) {
            this.machineName = machineName;
        }

        @Override
        public final Builder machineName(String machineName) {
            this.machineName = machineName;
            return this;
        }

        public final List<NdiDiscoveryServerConfig.Builder> getNdiDiscoveryServers() {
            List<NdiDiscoveryServerConfig.Builder> result = ___listOfNdiDiscoveryServerConfigCopier.copyToBuilder(this.ndiDiscoveryServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNdiDiscoveryServers(Collection<NdiDiscoveryServerConfig.BuilderImpl> ndiDiscoveryServers) {
            this.ndiDiscoveryServers = ___listOfNdiDiscoveryServerConfigCopier.copyFromBuilder(ndiDiscoveryServers);
        }

        @Override
        public final Builder ndiDiscoveryServers(Collection<NdiDiscoveryServerConfig> ndiDiscoveryServers) {
            this.ndiDiscoveryServers = ___listOfNdiDiscoveryServerConfigCopier.copy(ndiDiscoveryServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ndiDiscoveryServers(NdiDiscoveryServerConfig ... ndiDiscoveryServers) {
            this.ndiDiscoveryServers(Arrays.asList(ndiDiscoveryServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ndiDiscoveryServers(Consumer<NdiDiscoveryServerConfig.Builder> ... ndiDiscoveryServers) {
            this.ndiDiscoveryServers(Stream.of(ndiDiscoveryServers).map(c -> (NdiDiscoveryServerConfig)((NdiDiscoveryServerConfig.Builder)NdiDiscoveryServerConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NdiConfig build() {
            return new NdiConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NdiConfig> {
        public Builder ndiState(String var1);

        public Builder ndiState(NdiState var1);

        public Builder machineName(String var1);

        public Builder ndiDiscoveryServers(Collection<NdiDiscoveryServerConfig> var1);

        public Builder ndiDiscoveryServers(NdiDiscoveryServerConfig ... var1);

        public Builder ndiDiscoveryServers(Consumer<NdiDiscoveryServerConfig.Builder> ... var1);
    }
}

