/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork;
import software.amazon.awssdk.services.mediaconnect.model.GatewayState;
import software.amazon.awssdk.services.mediaconnect.model.MessageDetail;
import software.amazon.awssdk.services.mediaconnect.model.___listOfGatewayNetworkCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMessageDetailCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Gateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Gateway> {
    private static final SdkField<List<String>> EGRESS_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EgressCidrBlocks").getter(Gateway.getter(Gateway::egressCidrBlocks)).setter(Gateway.setter(Builder::egressCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressCidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(Gateway.getter(Gateway::gatewayArn)).setter(Gateway.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()}).build();
    private static final SdkField<List<MessageDetail>> GATEWAY_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayMessages").getter(Gateway.getter(Gateway::gatewayMessages)).setter(Gateway.setter(Builder::gatewayMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayState").getter(Gateway.getter(Gateway::gatewayStateAsString)).setter(Gateway.setter(Builder::gatewayState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayState").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Gateway.getter(Gateway::name)).setter(Gateway.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<GatewayNetwork>> NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Networks").getter(Gateway.getter(Gateway::networks)).setter(Gateway.setter(Builder::networks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_CIDR_BLOCKS_FIELD, GATEWAY_ARN_FIELD, GATEWAY_MESSAGES_FIELD, GATEWAY_STATE_FIELD, NAME_FIELD, NETWORKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Gateway.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> egressCidrBlocks;
    private final String gatewayArn;
    private final List<MessageDetail> gatewayMessages;
    private final String gatewayState;
    private final String name;
    private final List<GatewayNetwork> networks;

    private Gateway(BuilderImpl builder) {
        this.egressCidrBlocks = builder.egressCidrBlocks;
        this.gatewayArn = builder.gatewayArn;
        this.gatewayMessages = builder.gatewayMessages;
        this.gatewayState = builder.gatewayState;
        this.name = builder.name;
        this.networks = builder.networks;
    }

    public final boolean hasEgressCidrBlocks() {
        return this.egressCidrBlocks != null && !(this.egressCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> egressCidrBlocks() {
        return this.egressCidrBlocks;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final boolean hasGatewayMessages() {
        return this.gatewayMessages != null && !(this.gatewayMessages instanceof SdkAutoConstructList);
    }

    public final List<MessageDetail> gatewayMessages() {
        return this.gatewayMessages;
    }

    public final GatewayState gatewayState() {
        return GatewayState.fromValue(this.gatewayState);
    }

    public final String gatewayStateAsString() {
        return this.gatewayState;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNetworks() {
        return this.networks != null && !(this.networks instanceof SdkAutoConstructList);
    }

    public final List<GatewayNetwork> networks() {
        return this.networks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEgressCidrBlocks() ? this.egressCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayMessages() ? this.gatewayMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworks() ? this.networks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gateway)) {
            return false;
        }
        Gateway other = (Gateway)obj;
        return this.hasEgressCidrBlocks() == other.hasEgressCidrBlocks() && Objects.equals(this.egressCidrBlocks(), other.egressCidrBlocks()) && Objects.equals(this.gatewayArn(), other.gatewayArn()) && this.hasGatewayMessages() == other.hasGatewayMessages() && Objects.equals(this.gatewayMessages(), other.gatewayMessages()) && Objects.equals(this.gatewayStateAsString(), other.gatewayStateAsString()) && Objects.equals(this.name(), other.name()) && this.hasNetworks() == other.hasNetworks() && Objects.equals(this.networks(), other.networks());
    }

    public final String toString() {
        return ToString.builder((String)"Gateway").add("EgressCidrBlocks", this.hasEgressCidrBlocks() ? this.egressCidrBlocks() : null).add("GatewayArn", (Object)this.gatewayArn()).add("GatewayMessages", this.hasGatewayMessages() ? this.gatewayMessages() : null).add("GatewayState", (Object)this.gatewayStateAsString()).add("Name", (Object)this.name()).add("Networks", this.hasNetworks() ? this.networks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.egressCidrBlocks()));
            }
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "GatewayMessages": {
                return Optional.ofNullable(clazz.cast(this.gatewayMessages()));
            }
            case "GatewayState": {
                return Optional.ofNullable(clazz.cast(this.gatewayStateAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Networks": {
                return Optional.ofNullable(clazz.cast(this.networks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("egressCidrBlocks", EGRESS_CIDR_BLOCKS_FIELD);
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayMessages", GATEWAY_MESSAGES_FIELD);
        map.put("gatewayState", GATEWAY_STATE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networks", NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Gateway, T> g) {
        return obj -> g.apply((Gateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> egressCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private String gatewayArn;
        private List<MessageDetail> gatewayMessages = DefaultSdkAutoConstructList.getInstance();
        private String gatewayState;
        private String name;
        private List<GatewayNetwork> networks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Gateway model) {
            this.egressCidrBlocks(model.egressCidrBlocks);
            this.gatewayArn(model.gatewayArn);
            this.gatewayMessages(model.gatewayMessages);
            this.gatewayState(model.gatewayState);
            this.name(model.name);
            this.networks(model.networks);
        }

        public final Collection<String> getEgressCidrBlocks() {
            if (this.egressCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.egressCidrBlocks;
        }

        public final void setEgressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOfStringCopier.copy(egressCidrBlocks);
        }

        @Override
        public final Builder egressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOfStringCopier.copy(egressCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressCidrBlocks(String ... egressCidrBlocks) {
            this.egressCidrBlocks(Arrays.asList(egressCidrBlocks));
            return this;
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final List<MessageDetail.Builder> getGatewayMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.gatewayMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayMessages(Collection<MessageDetail.BuilderImpl> gatewayMessages) {
            this.gatewayMessages = ___listOfMessageDetailCopier.copyFromBuilder(gatewayMessages);
        }

        @Override
        public final Builder gatewayMessages(Collection<MessageDetail> gatewayMessages) {
            this.gatewayMessages = ___listOfMessageDetailCopier.copy(gatewayMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayMessages(MessageDetail ... gatewayMessages) {
            this.gatewayMessages(Arrays.asList(gatewayMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayMessages(Consumer<MessageDetail.Builder> ... gatewayMessages) {
            this.gatewayMessages(Stream.of(gatewayMessages).map(c -> (MessageDetail)((MessageDetail.Builder)MessageDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayState() {
            return this.gatewayState;
        }

        public final void setGatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
        }

        @Override
        public final Builder gatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        @Override
        public final Builder gatewayState(GatewayState gatewayState) {
            this.gatewayState(gatewayState == null ? null : gatewayState.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<GatewayNetwork.Builder> getNetworks() {
            List<GatewayNetwork.Builder> result = ___listOfGatewayNetworkCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<GatewayNetwork.BuilderImpl> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<GatewayNetwork> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(GatewayNetwork ... networks) {
            this.networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<GatewayNetwork.Builder> ... networks) {
            this.networks(Stream.of(networks).map(c -> (GatewayNetwork)((GatewayNetwork.Builder)GatewayNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Gateway build() {
            return new Gateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Gateway> {
        public Builder egressCidrBlocks(Collection<String> var1);

        public Builder egressCidrBlocks(String ... var1);

        public Builder gatewayArn(String var1);

        public Builder gatewayMessages(Collection<MessageDetail> var1);

        public Builder gatewayMessages(MessageDetail ... var1);

        public Builder gatewayMessages(Consumer<MessageDetail.Builder> ... var1);

        public Builder gatewayState(String var1);

        public Builder gatewayState(GatewayState var1);

        public Builder name(String var1);

        public Builder networks(Collection<GatewayNetwork> var1);

        public Builder networks(GatewayNetwork ... var1);

        public Builder networks(Consumer<GatewayNetwork.Builder> ... var1);
    }
}

