/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.InstanceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedGatewayInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedGatewayInstance> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(ListedGatewayInstance.getter(ListedGatewayInstance::gatewayArn)).setter(ListedGatewayInstance.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()}).build();
    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayInstanceArn").getter(ListedGatewayInstance.getter(ListedGatewayInstance::gatewayInstanceArn)).setter(ListedGatewayInstance.setter(Builder::gatewayInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListedGatewayInstance.getter(ListedGatewayInstance::instanceId)).setter(ListedGatewayInstance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceState").getter(ListedGatewayInstance.getter(ListedGatewayInstance::instanceStateAsString)).setter(ListedGatewayInstance.setter(Builder::instanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, GATEWAY_INSTANCE_ARN_FIELD, INSTANCE_ID_FIELD, INSTANCE_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListedGatewayInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gatewayArn;
    private final String gatewayInstanceArn;
    private final String instanceId;
    private final String instanceState;

    private ListedGatewayInstance(BuilderImpl builder) {
        this.gatewayArn = builder.gatewayArn;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String gatewayInstanceArn() {
        return this.gatewayInstanceArn;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceState instanceState() {
        return InstanceState.fromValue(this.instanceState);
    }

    public final String instanceStateAsString() {
        return this.instanceState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedGatewayInstance)) {
            return false;
        }
        ListedGatewayInstance other = (ListedGatewayInstance)obj;
        return Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.gatewayInstanceArn(), other.gatewayInstanceArn()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceStateAsString(), other.instanceStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListedGatewayInstance").add("GatewayArn", (Object)this.gatewayArn()).add("GatewayInstanceArn", (Object)this.gatewayInstanceArn()).add("InstanceId", (Object)this.instanceId()).add("InstanceState", (Object)this.instanceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "GatewayInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayInstanceArn()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceState": {
                return Optional.ofNullable(clazz.cast(this.instanceStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("instanceState", INSTANCE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedGatewayInstance, T> g) {
        return obj -> g.apply((ListedGatewayInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayArn;
        private String gatewayInstanceArn;
        private String instanceId;
        private String instanceState;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedGatewayInstance model) {
            this.gatewayArn(model.gatewayArn);
            this.gatewayInstanceArn(model.gatewayInstanceArn);
            this.instanceId(model.instanceId);
            this.instanceState(model.instanceState);
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayInstanceArn() {
            return this.gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceState() {
            return this.instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState(instanceState == null ? null : instanceState.toString());
            return this;
        }

        public ListedGatewayInstance build() {
            return new ListedGatewayInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedGatewayInstance> {
        public Builder gatewayArn(String var1);

        public Builder gatewayInstanceArn(String var1);

        public Builder instanceId(String var1);

        public Builder instanceState(String var1);

        public Builder instanceState(InstanceState var1);
    }
}

