/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.BridgeSource;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.___listOfBridgeSourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddBridgeSourcesResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, AddBridgeSourcesResponse> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(AddBridgeSourcesResponse.getter(AddBridgeSourcesResponse::bridgeArn)).setter(AddBridgeSourcesResponse.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()}).build();
    private static final SdkField<List<BridgeSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(AddBridgeSourcesResponse.getter(AddBridgeSourcesResponse::sources)).setter(AddBridgeSourcesResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BridgeSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddBridgeSourcesResponse.memberNameToFieldInitializer();
    private final String bridgeArn;
    private final List<BridgeSource> sources;

    private AddBridgeSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.sources = builder.sources;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<BridgeSource> sources() {
        return this.sources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddBridgeSourcesResponse)) {
            return false;
        }
        AddBridgeSourcesResponse other = (AddBridgeSourcesResponse)((Object)obj);
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"AddBridgeSourcesResponse").add("BridgeArn", (Object)this.bridgeArn()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddBridgeSourcesResponse, T> g) {
        return obj -> g.apply((AddBridgeSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String bridgeArn;
        private List<BridgeSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddBridgeSourcesResponse model) {
            super(model);
            this.bridgeArn(model.bridgeArn);
            this.sources(model.sources);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final List<BridgeSource.Builder> getSources() {
            List<BridgeSource.Builder> result = ___listOfBridgeSourceCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<BridgeSource.BuilderImpl> sources) {
            this.sources = ___listOfBridgeSourceCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<BridgeSource> sources) {
            this.sources = ___listOfBridgeSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(BridgeSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<BridgeSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (BridgeSource)((BridgeSource.Builder)BridgeSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddBridgeSourcesResponse build() {
            return new AddBridgeSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddBridgeSourcesResponse> {
        public Builder bridgeArn(String var1);

        public Builder sources(Collection<BridgeSource> var1);

        public Builder sources(BridgeSource ... var1);

        public Builder sources(Consumer<BridgeSource.Builder> ... var1);
    }
}

