/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveFlowMediaStreamResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, RemoveFlowMediaStreamResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(RemoveFlowMediaStreamResponse.getter(RemoveFlowMediaStreamResponse::flowArn)).setter(RemoveFlowMediaStreamResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamName").getter(RemoveFlowMediaStreamResponse.getter(RemoveFlowMediaStreamResponse::mediaStreamName)).setter(RemoveFlowMediaStreamResponse.setter(Builder::mediaStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, MEDIA_STREAM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveFlowMediaStreamResponse.memberNameToFieldInitializer();
    private final String flowArn;
    private final String mediaStreamName;

    private RemoveFlowMediaStreamResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.mediaStreamName = builder.mediaStreamName;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String mediaStreamName() {
        return this.mediaStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFlowMediaStreamResponse)) {
            return false;
        }
        RemoveFlowMediaStreamResponse other = (RemoveFlowMediaStreamResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.mediaStreamName(), other.mediaStreamName());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveFlowMediaStreamResponse").add("FlowArn", (Object)this.flowArn()).add("MediaStreamName", (Object)this.mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "MediaStreamName": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("mediaStreamName", MEDIA_STREAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveFlowMediaStreamResponse, T> g) {
        return obj -> g.apply((RemoveFlowMediaStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFlowMediaStreamResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.mediaStreamName(model.mediaStreamName);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getMediaStreamName() {
            return this.mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        @Override
        public RemoveFlowMediaStreamResponse build() {
            return new RemoveFlowMediaStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveFlowMediaStreamResponse> {
        public Builder flowArn(String var1);

        public Builder mediaStreamName(String var1);
    }
}

