/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceAttachment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBridgeFlowSourceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateBridgeFlowSourceRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateBridgeFlowSourceRequest.getter(UpdateBridgeFlowSourceRequest::flowArn)).setter(UpdateBridgeFlowSourceRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<VpcInterfaceAttachment> FLOW_VPC_INTERFACE_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowVpcInterfaceAttachment").getter(UpdateBridgeFlowSourceRequest.getter(UpdateBridgeFlowSourceRequest::flowVpcInterfaceAttachment)).setter(UpdateBridgeFlowSourceRequest.setter(Builder::flowVpcInterfaceAttachment)).constructor(VpcInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVpcInterfaceAttachment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, FLOW_VPC_INTERFACE_ATTACHMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("flowArn", FLOW_ARN_FIELD);
            this.put("flowVpcInterfaceAttachment", FLOW_VPC_INTERFACE_ATTACHMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String flowArn;
    private final VpcInterfaceAttachment flowVpcInterfaceAttachment;

    private UpdateBridgeFlowSourceRequest(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowVpcInterfaceAttachment = builder.flowVpcInterfaceAttachment;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final VpcInterfaceAttachment flowVpcInterfaceAttachment() {
        return this.flowVpcInterfaceAttachment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowVpcInterfaceAttachment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeFlowSourceRequest)) {
            return false;
        }
        UpdateBridgeFlowSourceRequest other = (UpdateBridgeFlowSourceRequest)obj;
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.flowVpcInterfaceAttachment(), other.flowVpcInterfaceAttachment());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBridgeFlowSourceRequest").add("FlowArn", (Object)this.flowArn()).add("FlowVpcInterfaceAttachment", (Object)this.flowVpcInterfaceAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "FlowVpcInterfaceAttachment": {
                return Optional.ofNullable(clazz.cast(this.flowVpcInterfaceAttachment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeFlowSourceRequest, T> g) {
        return obj -> g.apply((UpdateBridgeFlowSourceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowArn;
        private VpcInterfaceAttachment flowVpcInterfaceAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeFlowSourceRequest model) {
            this.flowArn(model.flowArn);
            this.flowVpcInterfaceAttachment(model.flowVpcInterfaceAttachment);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getFlowVpcInterfaceAttachment() {
            return this.flowVpcInterfaceAttachment != null ? this.flowVpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setFlowVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment != null ? flowVpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
            return this;
        }

        public UpdateBridgeFlowSourceRequest build() {
            return new UpdateBridgeFlowSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateBridgeFlowSourceRequest> {
        public Builder flowArn(String var1);

        public Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment var1);

        default public Builder flowVpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> flowVpcInterfaceAttachment) {
            return this.flowVpcInterfaceAttachment((VpcInterfaceAttachment)((VpcInterfaceAttachment.Builder)VpcInterfaceAttachment.builder().applyMutation(flowVpcInterfaceAttachment)).build());
        }
    }
}

