/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeNetworkSourceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBridgeSourceRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateBridgeSourceRequest> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(UpdateBridgeSourceRequest.getter(UpdateBridgeSourceRequest::bridgeArn)).setter(UpdateBridgeSourceRequest.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("bridgeArn").build()}).build();
    private static final SdkField<UpdateBridgeFlowSourceRequest> FLOW_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowSource").getter(UpdateBridgeSourceRequest.getter(UpdateBridgeSourceRequest::flowSource)).setter(UpdateBridgeSourceRequest.setter(Builder::flowSource)).constructor(UpdateBridgeFlowSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSource").build()}).build();
    private static final SdkField<UpdateBridgeNetworkSourceRequest> NETWORK_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkSource").getter(UpdateBridgeSourceRequest.getter(UpdateBridgeSourceRequest::networkSource)).setter(UpdateBridgeSourceRequest.setter(Builder::networkSource)).constructor(UpdateBridgeNetworkSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSource").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceName").getter(UpdateBridgeSourceRequest.getter(UpdateBridgeSourceRequest::sourceName)).setter(UpdateBridgeSourceRequest.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, FLOW_SOURCE_FIELD, NETWORK_SOURCE_FIELD, SOURCE_NAME_FIELD));
    private final String bridgeArn;
    private final UpdateBridgeFlowSourceRequest flowSource;
    private final UpdateBridgeNetworkSourceRequest networkSource;
    private final String sourceName;

    private UpdateBridgeSourceRequest(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.flowSource = builder.flowSource;
        this.networkSource = builder.networkSource;
        this.sourceName = builder.sourceName;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final UpdateBridgeFlowSourceRequest flowSource() {
        return this.flowSource;
    }

    public final UpdateBridgeNetworkSourceRequest networkSource() {
        return this.networkSource;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeSourceRequest)) {
            return false;
        }
        UpdateBridgeSourceRequest other = (UpdateBridgeSourceRequest)((Object)obj);
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.flowSource(), other.flowSource()) && Objects.equals(this.networkSource(), other.networkSource()) && Objects.equals(this.sourceName(), other.sourceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBridgeSourceRequest").add("BridgeArn", (Object)this.bridgeArn()).add("FlowSource", (Object)this.flowSource()).add("NetworkSource", (Object)this.networkSource()).add("SourceName", (Object)this.sourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "FlowSource": {
                return Optional.ofNullable(clazz.cast(this.flowSource()));
            }
            case "NetworkSource": {
                return Optional.ofNullable(clazz.cast(this.networkSource()));
            }
            case "SourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeSourceRequest, T> g) {
        return obj -> g.apply((UpdateBridgeSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String bridgeArn;
        private UpdateBridgeFlowSourceRequest flowSource;
        private UpdateBridgeNetworkSourceRequest networkSource;
        private String sourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeSourceRequest model) {
            super(model);
            this.bridgeArn(model.bridgeArn);
            this.flowSource(model.flowSource);
            this.networkSource(model.networkSource);
            this.sourceName(model.sourceName);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final UpdateBridgeFlowSourceRequest.Builder getFlowSource() {
            return this.flowSource != null ? this.flowSource.toBuilder() : null;
        }

        public final void setFlowSource(UpdateBridgeFlowSourceRequest.BuilderImpl flowSource) {
            this.flowSource = flowSource != null ? flowSource.build() : null;
        }

        @Override
        public final Builder flowSource(UpdateBridgeFlowSourceRequest flowSource) {
            this.flowSource = flowSource;
            return this;
        }

        public final UpdateBridgeNetworkSourceRequest.Builder getNetworkSource() {
            return this.networkSource != null ? this.networkSource.toBuilder() : null;
        }

        public final void setNetworkSource(UpdateBridgeNetworkSourceRequest.BuilderImpl networkSource) {
            this.networkSource = networkSource != null ? networkSource.build() : null;
        }

        @Override
        public final Builder networkSource(UpdateBridgeNetworkSourceRequest networkSource) {
            this.networkSource = networkSource;
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBridgeSourceRequest build() {
            return new UpdateBridgeSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBridgeSourceRequest> {
        public Builder bridgeArn(String var1);

        public Builder flowSource(UpdateBridgeFlowSourceRequest var1);

        default public Builder flowSource(Consumer<UpdateBridgeFlowSourceRequest.Builder> flowSource) {
            return this.flowSource((UpdateBridgeFlowSourceRequest)((UpdateBridgeFlowSourceRequest.Builder)UpdateBridgeFlowSourceRequest.builder().applyMutation(flowSource)).build());
        }

        public Builder networkSource(UpdateBridgeNetworkSourceRequest var1);

        default public Builder networkSource(Consumer<UpdateBridgeNetworkSourceRequest.Builder> networkSource) {
            return this.networkSource((UpdateBridgeNetworkSourceRequest)((UpdateBridgeNetworkSourceRequest.Builder)UpdateBridgeNetworkSourceRequest.builder().applyMutation(networkSource)).build());
        }

        public Builder sourceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

