/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailoverMode {
    MERGE("MERGE"),
    FAILOVER("FAILOVER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailoverMode> VALUE_MAP;
    private final String value;

    private FailoverMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailoverMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailoverMode> knownValues() {
        EnumSet<FailoverMode> knownValues = EnumSet.allOf(FailoverMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailoverMode.class, FailoverMode::toString);
    }
}

