/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowMediaStreamResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, UpdateFlowMediaStreamResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateFlowMediaStreamResponse.getter(UpdateFlowMediaStreamResponse::flowArn)).setter(UpdateFlowMediaStreamResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<MediaStream> MEDIA_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaStream").getter(UpdateFlowMediaStreamResponse.getter(UpdateFlowMediaStreamResponse::mediaStream)).setter(UpdateFlowMediaStreamResponse.setter(Builder::mediaStream)).constructor(MediaStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, MEDIA_STREAM_FIELD));
    private final String flowArn;
    private final MediaStream mediaStream;

    private UpdateFlowMediaStreamResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.mediaStream = builder.mediaStream;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final MediaStream mediaStream() {
        return this.mediaStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowMediaStreamResponse)) {
            return false;
        }
        UpdateFlowMediaStreamResponse other = (UpdateFlowMediaStreamResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.mediaStream(), other.mediaStream());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowMediaStreamResponse").add("FlowArn", (Object)this.flowArn()).add("MediaStream", (Object)this.mediaStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "MediaStream": {
                return Optional.ofNullable(clazz.cast(this.mediaStream()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowMediaStreamResponse, T> g) {
        return obj -> g.apply((UpdateFlowMediaStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private MediaStream mediaStream;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowMediaStreamResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.mediaStream(model.mediaStream);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final MediaStream.Builder getMediaStream() {
            return this.mediaStream != null ? this.mediaStream.toBuilder() : null;
        }

        public final void setMediaStream(MediaStream.BuilderImpl mediaStream) {
            this.mediaStream = mediaStream != null ? mediaStream.build() : null;
        }

        @Override
        public final Builder mediaStream(MediaStream mediaStream) {
            this.mediaStream = mediaStream;
            return this;
        }

        @Override
        public UpdateFlowMediaStreamResponse build() {
            return new UpdateFlowMediaStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowMediaStreamResponse> {
        public Builder flowArn(String var1);

        public Builder mediaStream(MediaStream var1);

        default public Builder mediaStream(Consumer<MediaStream.Builder> mediaStream) {
            return this.mediaStream((MediaStream)((MediaStream.Builder)MediaStream.builder().applyMutation(mediaStream)).build());
        }
    }
}

