/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedGatewayInstance;

public class ListGatewayInstancesIterable
implements SdkIterable<ListGatewayInstancesResponse> {
    private final MediaConnectClient client;
    private final ListGatewayInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGatewayInstancesIterable(MediaConnectClient client, ListGatewayInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGatewayInstancesResponseFetcher();
    }

    public Iterator<ListGatewayInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedGatewayInstance> instances() {
        Function<ListGatewayInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGatewayInstancesResponseFetcher
    implements SyncPageFetcher<ListGatewayInstancesResponse> {
        private ListGatewayInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGatewayInstancesResponse nextPage(ListGatewayInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayInstancesIterable.this.client.listGatewayInstances(ListGatewayInstancesIterable.this.firstRequest);
            }
            return ListGatewayInstancesIterable.this.client.listGatewayInstances((ListGatewayInstancesRequest)((Object)ListGatewayInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

