/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediaconnect.DefaultMediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.DefaultMediaConnectBaseClientBuilder;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClientBuilder;
import software.amazon.awssdk.services.mediaconnect.MediaConnectServiceClientConfiguration;
import software.amazon.awssdk.services.mediaconnect.endpoints.MediaConnectEndpointProvider;

@SdkInternalApi
final class DefaultMediaConnectAsyncClientBuilder
extends DefaultMediaConnectBaseClientBuilder<MediaConnectAsyncClientBuilder, MediaConnectAsyncClient>
implements MediaConnectAsyncClientBuilder {
    DefaultMediaConnectAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaConnectAsyncClientBuilder endpointProvider(MediaConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaConnectAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaConnectAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaConnectServiceClientConfiguration serviceClientConfiguration = MediaConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaConnectAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

