/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediaconnect.DefaultMediaConnectBaseClientBuilder;
import software.amazon.awssdk.services.mediaconnect.DefaultMediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClientBuilder;
import software.amazon.awssdk.services.mediaconnect.MediaConnectServiceClientConfiguration;
import software.amazon.awssdk.services.mediaconnect.endpoints.MediaConnectEndpointProvider;

@SdkInternalApi
final class DefaultMediaConnectClientBuilder
extends DefaultMediaConnectBaseClientBuilder<MediaConnectClientBuilder, MediaConnectClient>
implements MediaConnectClientBuilder {
    DefaultMediaConnectClientBuilder() {
    }

    @Override
    public DefaultMediaConnectClientBuilder endpointProvider(MediaConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaConnectClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaConnectClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaConnectServiceClientConfiguration serviceClientConfiguration = MediaConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaConnectClient(serviceClientConfiguration, clientConfiguration);
    }
}

