/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.EncoderProfile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncodingParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncodingParameters> {
    private static final SdkField<Double> COMPRESSION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CompressionFactor").getter(EncodingParameters.getter(EncodingParameters::compressionFactor)).setter(EncodingParameters.setter(Builder::compressionFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compressionFactor").build()}).build();
    private static final SdkField<String> ENCODER_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncoderProfile").getter(EncodingParameters.getter(EncodingParameters::encoderProfileAsString)).setter(EncodingParameters.setter(Builder::encoderProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderProfile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPRESSION_FACTOR_FIELD, ENCODER_PROFILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double compressionFactor;
    private final String encoderProfile;

    private EncodingParameters(BuilderImpl builder) {
        this.compressionFactor = builder.compressionFactor;
        this.encoderProfile = builder.encoderProfile;
    }

    public final Double compressionFactor() {
        return this.compressionFactor;
    }

    public final EncoderProfile encoderProfile() {
        return EncoderProfile.fromValue(this.encoderProfile);
    }

    public final String encoderProfileAsString() {
        return this.encoderProfile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoderProfileAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncodingParameters)) {
            return false;
        }
        EncodingParameters other = (EncodingParameters)obj;
        return Objects.equals(this.compressionFactor(), other.compressionFactor()) && Objects.equals(this.encoderProfileAsString(), other.encoderProfileAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EncodingParameters").add("CompressionFactor", (Object)this.compressionFactor()).add("EncoderProfile", (Object)this.encoderProfileAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompressionFactor": {
                return Optional.ofNullable(clazz.cast(this.compressionFactor()));
            }
            case "EncoderProfile": {
                return Optional.ofNullable(clazz.cast(this.encoderProfileAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncodingParameters, T> g) {
        return obj -> g.apply((EncodingParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double compressionFactor;
        private String encoderProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(EncodingParameters model) {
            this.compressionFactor(model.compressionFactor);
            this.encoderProfile(model.encoderProfile);
        }

        public final Double getCompressionFactor() {
            return this.compressionFactor;
        }

        public final void setCompressionFactor(Double compressionFactor) {
            this.compressionFactor = compressionFactor;
        }

        @Override
        public final Builder compressionFactor(Double compressionFactor) {
            this.compressionFactor = compressionFactor;
            return this;
        }

        public final String getEncoderProfile() {
            return this.encoderProfile;
        }

        public final void setEncoderProfile(String encoderProfile) {
            this.encoderProfile = encoderProfile;
        }

        @Override
        public final Builder encoderProfile(String encoderProfile) {
            this.encoderProfile = encoderProfile;
            return this;
        }

        @Override
        public final Builder encoderProfile(EncoderProfile encoderProfile) {
            this.encoderProfile(encoderProfile == null ? null : encoderProfile.toString());
            return this;
        }

        public EncodingParameters build() {
            return new EncodingParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncodingParameters> {
        public Builder compressionFactor(Double var1);

        public Builder encoderProfile(String var1);

        public Builder encoderProfile(EncoderProfile var1);
    }
}

