/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Algorithm {
    AES128("aes128"),
    AES192("aes192"),
    AES256("aes256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Algorithm> VALUE_MAP;
    private final String value;

    private Algorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Algorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Algorithm> knownValues() {
        EnumSet<Algorithm> knownValues = EnumSet.allOf(Algorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Algorithm.class, Algorithm::toString);
    }
}

