/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSpecification> {
    private static final SdkField<Integer> RESERVED_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReservedBitrate").getter(ResourceSpecification.getter(ResourceSpecification::reservedBitrate)).setter(ResourceSpecification.setter(Builder::reservedBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedBitrate").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceSpecification.getter(ResourceSpecification::resourceTypeAsString)).setter(ResourceSpecification.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_BITRATE_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer reservedBitrate;
    private final String resourceType;

    private ResourceSpecification(BuilderImpl builder) {
        this.reservedBitrate = builder.reservedBitrate;
        this.resourceType = builder.resourceType;
    }

    public final Integer reservedBitrate() {
        return this.reservedBitrate;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpecification)) {
            return false;
        }
        ResourceSpecification other = (ResourceSpecification)obj;
        return Objects.equals(this.reservedBitrate(), other.reservedBitrate()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSpecification").add("ReservedBitrate", (Object)this.reservedBitrate()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedBitrate": {
                return Optional.ofNullable(clazz.cast(this.reservedBitrate()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSpecification, T> g) {
        return obj -> g.apply((ResourceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer reservedBitrate;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpecification model) {
            this.reservedBitrate(model.reservedBitrate);
            this.resourceType(model.resourceType);
        }

        public final Integer getReservedBitrate() {
            return this.reservedBitrate;
        }

        public final void setReservedBitrate(Integer reservedBitrate) {
            this.reservedBitrate = reservedBitrate;
        }

        @Override
        @Transient
        public final Builder reservedBitrate(Integer reservedBitrate) {
            this.reservedBitrate = reservedBitrate;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public ResourceSpecification build() {
            return new ResourceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSpecification> {
        public Builder reservedBitrate(Integer var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);
    }
}

