/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Colorimetry;
import software.amazon.awssdk.services.mediaconnect.model.Range;
import software.amazon.awssdk.services.mediaconnect.model.ScanMode;
import software.amazon.awssdk.services.mediaconnect.model.Tcs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FmtpRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FmtpRequest> {
    private static final SdkField<String> CHANNEL_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelOrder").getter(FmtpRequest.getter(FmtpRequest::channelOrder)).setter(FmtpRequest.setter(Builder::channelOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelOrder").build()}).build();
    private static final SdkField<String> COLORIMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Colorimetry").getter(FmtpRequest.getter(FmtpRequest::colorimetryAsString)).setter(FmtpRequest.setter(Builder::colorimetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorimetry").build()}).build();
    private static final SdkField<String> EXACT_FRAMERATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExactFramerate").getter(FmtpRequest.getter(FmtpRequest::exactFramerate)).setter(FmtpRequest.setter(Builder::exactFramerate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactFramerate").build()}).build();
    private static final SdkField<String> PAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Par").getter(FmtpRequest.getter(FmtpRequest::par)).setter(FmtpRequest.setter(Builder::par)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("par").build()}).build();
    private static final SdkField<String> RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Range").getter(FmtpRequest.getter(FmtpRequest::rangeAsString)).setter(FmtpRequest.setter(Builder::range)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("range").build()}).build();
    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanMode").getter(FmtpRequest.getter(FmtpRequest::scanModeAsString)).setter(FmtpRequest.setter(Builder::scanMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanMode").build()}).build();
    private static final SdkField<String> TCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tcs").getter(FmtpRequest.getter(FmtpRequest::tcsAsString)).setter(FmtpRequest.setter(Builder::tcs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ORDER_FIELD, COLORIMETRY_FIELD, EXACT_FRAMERATE_FIELD, PAR_FIELD, RANGE_FIELD, SCAN_MODE_FIELD, TCS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelOrder;
    private final String colorimetry;
    private final String exactFramerate;
    private final String par;
    private final String range;
    private final String scanMode;
    private final String tcs;

    private FmtpRequest(BuilderImpl builder) {
        this.channelOrder = builder.channelOrder;
        this.colorimetry = builder.colorimetry;
        this.exactFramerate = builder.exactFramerate;
        this.par = builder.par;
        this.range = builder.range;
        this.scanMode = builder.scanMode;
        this.tcs = builder.tcs;
    }

    public final String channelOrder() {
        return this.channelOrder;
    }

    public final Colorimetry colorimetry() {
        return Colorimetry.fromValue(this.colorimetry);
    }

    public final String colorimetryAsString() {
        return this.colorimetry;
    }

    public final String exactFramerate() {
        return this.exactFramerate;
    }

    public final String par() {
        return this.par;
    }

    public final Range range() {
        return Range.fromValue(this.range);
    }

    public final String rangeAsString() {
        return this.range;
    }

    public final ScanMode scanMode() {
        return ScanMode.fromValue(this.scanMode);
    }

    public final String scanModeAsString() {
        return this.scanMode;
    }

    public final Tcs tcs() {
        return Tcs.fromValue(this.tcs);
    }

    public final String tcsAsString() {
        return this.tcs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorimetryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exactFramerate());
        hashCode = 31 * hashCode + Objects.hashCode(this.par());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tcsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FmtpRequest)) {
            return false;
        }
        FmtpRequest other = (FmtpRequest)obj;
        return Objects.equals(this.channelOrder(), other.channelOrder()) && Objects.equals(this.colorimetryAsString(), other.colorimetryAsString()) && Objects.equals(this.exactFramerate(), other.exactFramerate()) && Objects.equals(this.par(), other.par()) && Objects.equals(this.rangeAsString(), other.rangeAsString()) && Objects.equals(this.scanModeAsString(), other.scanModeAsString()) && Objects.equals(this.tcsAsString(), other.tcsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FmtpRequest").add("ChannelOrder", (Object)this.channelOrder()).add("Colorimetry", (Object)this.colorimetryAsString()).add("ExactFramerate", (Object)this.exactFramerate()).add("Par", (Object)this.par()).add("Range", (Object)this.rangeAsString()).add("ScanMode", (Object)this.scanModeAsString()).add("Tcs", (Object)this.tcsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelOrder": {
                return Optional.ofNullable(clazz.cast(this.channelOrder()));
            }
            case "Colorimetry": {
                return Optional.ofNullable(clazz.cast(this.colorimetryAsString()));
            }
            case "ExactFramerate": {
                return Optional.ofNullable(clazz.cast(this.exactFramerate()));
            }
            case "Par": {
                return Optional.ofNullable(clazz.cast(this.par()));
            }
            case "Range": {
                return Optional.ofNullable(clazz.cast(this.rangeAsString()));
            }
            case "ScanMode": {
                return Optional.ofNullable(clazz.cast(this.scanModeAsString()));
            }
            case "Tcs": {
                return Optional.ofNullable(clazz.cast(this.tcsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FmtpRequest, T> g) {
        return obj -> g.apply((FmtpRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelOrder;
        private String colorimetry;
        private String exactFramerate;
        private String par;
        private String range;
        private String scanMode;
        private String tcs;

        private BuilderImpl() {
        }

        private BuilderImpl(FmtpRequest model) {
            this.channelOrder(model.channelOrder);
            this.colorimetry(model.colorimetry);
            this.exactFramerate(model.exactFramerate);
            this.par(model.par);
            this.range(model.range);
            this.scanMode(model.scanMode);
            this.tcs(model.tcs);
        }

        public final String getChannelOrder() {
            return this.channelOrder;
        }

        public final void setChannelOrder(String channelOrder) {
            this.channelOrder = channelOrder;
        }

        @Override
        @Transient
        public final Builder channelOrder(String channelOrder) {
            this.channelOrder = channelOrder;
            return this;
        }

        public final String getColorimetry() {
            return this.colorimetry;
        }

        public final void setColorimetry(String colorimetry) {
            this.colorimetry = colorimetry;
        }

        @Override
        @Transient
        public final Builder colorimetry(String colorimetry) {
            this.colorimetry = colorimetry;
            return this;
        }

        @Override
        @Transient
        public final Builder colorimetry(Colorimetry colorimetry) {
            this.colorimetry(colorimetry == null ? null : colorimetry.toString());
            return this;
        }

        public final String getExactFramerate() {
            return this.exactFramerate;
        }

        public final void setExactFramerate(String exactFramerate) {
            this.exactFramerate = exactFramerate;
        }

        @Override
        @Transient
        public final Builder exactFramerate(String exactFramerate) {
            this.exactFramerate = exactFramerate;
            return this;
        }

        public final String getPar() {
            return this.par;
        }

        public final void setPar(String par) {
            this.par = par;
        }

        @Override
        @Transient
        public final Builder par(String par) {
            this.par = par;
            return this;
        }

        public final String getRange() {
            return this.range;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        @Override
        @Transient
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        @Override
        @Transient
        public final Builder range(Range range) {
            this.range(range == null ? null : range.toString());
            return this;
        }

        public final String getScanMode() {
            return this.scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        @Transient
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        @Transient
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final String getTcs() {
            return this.tcs;
        }

        public final void setTcs(String tcs) {
            this.tcs = tcs;
        }

        @Override
        @Transient
        public final Builder tcs(String tcs) {
            this.tcs = tcs;
            return this;
        }

        @Override
        @Transient
        public final Builder tcs(Tcs tcs) {
            this.tcs(tcs == null ? null : tcs.toString());
            return this;
        }

        public FmtpRequest build() {
            return new FmtpRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FmtpRequest> {
        public Builder channelOrder(String var1);

        public Builder colorimetry(String var1);

        public Builder colorimetry(Colorimetry var1);

        public Builder exactFramerate(String var1);

        public Builder par(String var1);

        public Builder range(String var1);

        public Builder range(Range var1);

        public Builder scanMode(String var1);

        public Builder scanMode(ScanMode var1);

        public Builder tcs(String var1);

        public Builder tcs(Tcs var1);
    }
}

