/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Tcs {
    SDR("SDR"),
    PQ("PQ"),
    HLG("HLG"),
    LINEAR("LINEAR"),
    BT2100_LINPQ("BT2100LINPQ"),
    BT2100_LINHLG("BT2100LINHLG"),
    ST2065_1("ST2065-1"),
    ST428_1("ST428-1"),
    DENSITY("DENSITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Tcs(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Tcs fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Tcs.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Tcs> knownValues() {
        return Stream.of(Tcs.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

