/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.DurationUnits;
import software.amazon.awssdk.services.mediaconnect.model.PriceUnits;
import software.amazon.awssdk.services.mediaconnect.model.ReservationState;
import software.amazon.awssdk.services.mediaconnect.model.ResourceSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Reservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Reservation> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(Reservation.getter(Reservation::currencyCode)).setter(Reservation.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(Reservation.getter(Reservation::duration)).setter(Reservation.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationUnits").getter(Reservation.getter(Reservation::durationUnitsAsString)).setter(Reservation.setter(Builder::durationUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()}).build();
    private static final SdkField<String> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("End").getter(Reservation.getter(Reservation::end)).setter(Reservation.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()}).build();
    private static final SdkField<String> OFFERING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingArn").getter(Reservation.getter(Reservation::offeringArn)).setter(Reservation.setter(Builder::offeringArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringArn").build()}).build();
    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingDescription").getter(Reservation.getter(Reservation::offeringDescription)).setter(Reservation.setter(Builder::offeringDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build()}).build();
    private static final SdkField<String> PRICE_PER_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricePerUnit").getter(Reservation.getter(Reservation::pricePerUnit)).setter(Reservation.setter(Builder::pricePerUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricePerUnit").build()}).build();
    private static final SdkField<String> PRICE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PriceUnits").getter(Reservation.getter(Reservation::priceUnitsAsString)).setter(Reservation.setter(Builder::priceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priceUnits").build()}).build();
    private static final SdkField<String> RESERVATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationArn").getter(Reservation.getter(Reservation::reservationArn)).setter(Reservation.setter(Builder::reservationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationArn").build()}).build();
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationName").getter(Reservation.getter(Reservation::reservationName)).setter(Reservation.setter(Builder::reservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationName").build()}).build();
    private static final SdkField<String> RESERVATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationState").getter(Reservation.getter(Reservation::reservationStateAsString)).setter(Reservation.setter(Builder::reservationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationState").build()}).build();
    private static final SdkField<ResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSpecification").getter(Reservation.getter(Reservation::resourceSpecification)).setter(Reservation.setter(Builder::resourceSpecification)).constructor(ResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Start").getter(Reservation.getter(Reservation::start)).setter(Reservation.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, DURATION_FIELD, DURATION_UNITS_FIELD, END_FIELD, OFFERING_ARN_FIELD, OFFERING_DESCRIPTION_FIELD, PRICE_PER_UNIT_FIELD, PRICE_UNITS_FIELD, RESERVATION_ARN_FIELD, RESERVATION_NAME_FIELD, RESERVATION_STATE_FIELD, RESOURCE_SPECIFICATION_FIELD, START_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final Integer duration;
    private final String durationUnits;
    private final String end;
    private final String offeringArn;
    private final String offeringDescription;
    private final String pricePerUnit;
    private final String priceUnits;
    private final String reservationArn;
    private final String reservationName;
    private final String reservationState;
    private final ResourceSpecification resourceSpecification;
    private final String start;

    private Reservation(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.end = builder.end;
        this.offeringArn = builder.offeringArn;
        this.offeringDescription = builder.offeringDescription;
        this.pricePerUnit = builder.pricePerUnit;
        this.priceUnits = builder.priceUnits;
        this.reservationArn = builder.reservationArn;
        this.reservationName = builder.reservationName;
        this.reservationState = builder.reservationState;
        this.resourceSpecification = builder.resourceSpecification;
        this.start = builder.start;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final DurationUnits durationUnits() {
        return DurationUnits.fromValue(this.durationUnits);
    }

    public final String durationUnitsAsString() {
        return this.durationUnits;
    }

    public final String end() {
        return this.end;
    }

    public final String offeringArn() {
        return this.offeringArn;
    }

    public final String offeringDescription() {
        return this.offeringDescription;
    }

    public final String pricePerUnit() {
        return this.pricePerUnit;
    }

    public final PriceUnits priceUnits() {
        return PriceUnits.fromValue(this.priceUnits);
    }

    public final String priceUnitsAsString() {
        return this.priceUnits;
    }

    public final String reservationArn() {
        return this.reservationArn;
    }

    public final String reservationName() {
        return this.reservationName;
    }

    public final ReservationState reservationState() {
        return ReservationState.fromValue(this.reservationState);
    }

    public final String reservationStateAsString() {
        return this.reservationState;
    }

    public final ResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final String start() {
        return this.start;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricePerUnit());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation)obj;
        return Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.durationUnitsAsString(), other.durationUnitsAsString()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.offeringArn(), other.offeringArn()) && Objects.equals(this.offeringDescription(), other.offeringDescription()) && Objects.equals(this.pricePerUnit(), other.pricePerUnit()) && Objects.equals(this.priceUnitsAsString(), other.priceUnitsAsString()) && Objects.equals(this.reservationArn(), other.reservationArn()) && Objects.equals(this.reservationName(), other.reservationName()) && Objects.equals(this.reservationStateAsString(), other.reservationStateAsString()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.start(), other.start());
    }

    public final String toString() {
        return ToString.builder((String)"Reservation").add("CurrencyCode", (Object)this.currencyCode()).add("Duration", (Object)this.duration()).add("DurationUnits", (Object)this.durationUnitsAsString()).add("End", (Object)this.end()).add("OfferingArn", (Object)this.offeringArn()).add("OfferingDescription", (Object)this.offeringDescription()).add("PricePerUnit", (Object)this.pricePerUnit()).add("PriceUnits", (Object)this.priceUnitsAsString()).add("ReservationArn", (Object)this.reservationArn()).add("ReservationName", (Object)this.reservationName()).add("ReservationState", (Object)this.reservationStateAsString()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("Start", (Object)this.start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "DurationUnits": {
                return Optional.ofNullable(clazz.cast(this.durationUnitsAsString()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "OfferingArn": {
                return Optional.ofNullable(clazz.cast(this.offeringArn()));
            }
            case "OfferingDescription": {
                return Optional.ofNullable(clazz.cast(this.offeringDescription()));
            }
            case "PricePerUnit": {
                return Optional.ofNullable(clazz.cast(this.pricePerUnit()));
            }
            case "PriceUnits": {
                return Optional.ofNullable(clazz.cast(this.priceUnitsAsString()));
            }
            case "ReservationArn": {
                return Optional.ofNullable(clazz.cast(this.reservationArn()));
            }
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
            case "ReservationState": {
                return Optional.ofNullable(clazz.cast(this.reservationStateAsString()));
            }
            case "ResourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Reservation, T> g) {
        return obj -> g.apply((Reservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private Integer duration;
        private String durationUnits;
        private String end;
        private String offeringArn;
        private String offeringDescription;
        private String pricePerUnit;
        private String priceUnits;
        private String reservationArn;
        private String reservationName;
        private String reservationState;
        private ResourceSpecification resourceSpecification;
        private String start;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.durationUnits(model.durationUnits);
            this.end(model.end);
            this.offeringArn(model.offeringArn);
            this.offeringDescription(model.offeringDescription);
            this.pricePerUnit(model.pricePerUnit);
            this.priceUnits(model.priceUnits);
            this.reservationArn(model.reservationArn);
            this.reservationName(model.reservationName);
            this.reservationState(model.reservationState);
            this.resourceSpecification(model.resourceSpecification);
            this.start(model.start);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getDurationUnits() {
            return this.durationUnits;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        @Override
        @Transient
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        @Transient
        public final Builder durationUnits(DurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final String getEnd() {
            return this.end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        @Transient
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final String getOfferingArn() {
            return this.offeringArn;
        }

        public final void setOfferingArn(String offeringArn) {
            this.offeringArn = offeringArn;
        }

        @Override
        @Transient
        public final Builder offeringArn(String offeringArn) {
            this.offeringArn = offeringArn;
            return this;
        }

        public final String getOfferingDescription() {
            return this.offeringDescription;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        @Override
        @Transient
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final String getPricePerUnit() {
            return this.pricePerUnit;
        }

        public final void setPricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
        }

        @Override
        @Transient
        public final Builder pricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
            return this;
        }

        public final String getPriceUnits() {
            return this.priceUnits;
        }

        public final void setPriceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
        }

        @Override
        @Transient
        public final Builder priceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
            return this;
        }

        @Override
        @Transient
        public final Builder priceUnits(PriceUnits priceUnits) {
            this.priceUnits(priceUnits == null ? null : priceUnits.toString());
            return this;
        }

        public final String getReservationArn() {
            return this.reservationArn;
        }

        public final void setReservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
        }

        @Override
        @Transient
        public final Builder reservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
            return this;
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        @Transient
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final String getReservationState() {
            return this.reservationState;
        }

        public final void setReservationState(String reservationState) {
            this.reservationState = reservationState;
        }

        @Override
        @Transient
        public final Builder reservationState(String reservationState) {
            this.reservationState = reservationState;
            return this;
        }

        @Override
        @Transient
        public final Builder reservationState(ReservationState reservationState) {
            this.reservationState(reservationState == null ? null : reservationState.toString());
            return this;
        }

        public final ResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceSpecification(ResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getStart() {
            return this.start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        @Transient
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public Reservation build() {
            return new Reservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Reservation> {
        public Builder currencyCode(String var1);

        public Builder duration(Integer var1);

        public Builder durationUnits(String var1);

        public Builder durationUnits(DurationUnits var1);

        public Builder end(String var1);

        public Builder offeringArn(String var1);

        public Builder offeringDescription(String var1);

        public Builder pricePerUnit(String var1);

        public Builder priceUnits(String var1);

        public Builder priceUnits(PriceUnits var1);

        public Builder reservationArn(String var1);

        public Builder reservationName(String var1);

        public Builder reservationState(String var1);

        public Builder reservationState(ReservationState var1);

        public Builder resourceSpecification(ResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ResourceSpecification)((ResourceSpecification.Builder)ResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder start(String var1);
    }
}

