/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncodingName {
    JXSV("jxsv"),
    RAW("raw"),
    SMPTE291("smpte291"),
    PCM("pcm"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EncodingName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncodingName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EncodingName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncodingName> knownValues() {
        return Stream.of(EncodingName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

