/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Colorimetry {
    BT601("BT601"),
    BT709("BT709"),
    BT2020("BT2020"),
    BT2100("BT2100"),
    ST2065_1("ST2065-1"),
    ST2065_3("ST2065-3"),
    XYZ("XYZ"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Colorimetry(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Colorimetry fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Colorimetry.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Colorimetry> knownValues() {
        return Stream.of(Colorimetry.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

