/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservationResponse extends MediaConnectResponse implements
        ToCopyableBuilder<DescribeReservationResponse.Builder, DescribeReservationResponse> {
    private static final SdkField<Reservation> RESERVATION_FIELD = SdkField.<Reservation> builder(MarshallingType.SDK_POJO)
            .memberName("Reservation").getter(getter(DescribeReservationResponse::reservation))
            .setter(setter(Builder::reservation)).constructor(Reservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_FIELD));

    private final Reservation reservation;

    private DescribeReservationResponse(BuilderImpl builder) {
        super(builder);
        this.reservation = builder.reservation;
    }

    /**
     * Returns the value of the Reservation property for this object.
     * 
     * @return The value of the Reservation property for this object.
     */
    public final Reservation reservation() {
        return reservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservationResponse)) {
            return false;
        }
        DescribeReservationResponse other = (DescribeReservationResponse) obj;
        return Objects.equals(reservation(), other.reservation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservationResponse").add("Reservation", reservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reservation":
            return Optional.ofNullable(clazz.cast(reservation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservationResponse, T> g) {
        return obj -> g.apply((DescribeReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReservationResponse> {
        /**
         * Sets the value of the Reservation property for this object.
         *
         * @param reservation
         *        The new value for the Reservation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservation(Reservation reservation);

        /**
         * Sets the value of the Reservation property for this object.
         *
         * This is a convenience that creates an instance of the {@link Reservation.Builder} avoiding the need to create
         * one manually via {@link Reservation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Reservation.Builder#build()} is called immediately and its result
         * is passed to {@link #reservation(Reservation)}.
         * 
         * @param reservation
         *        a consumer that will call methods on {@link Reservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservation(Reservation)
         */
        default Builder reservation(Consumer<Reservation.Builder> reservation) {
            return reservation(Reservation.builder().applyMutation(reservation).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private Reservation reservation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservationResponse model) {
            super(model);
            reservation(model.reservation);
        }

        public final Reservation.Builder getReservation() {
            return reservation != null ? reservation.toBuilder() : null;
        }

        @Override
        public final Builder reservation(Reservation reservation) {
            this.reservation = reservation;
            return this;
        }

        public final void setReservation(Reservation.BuilderImpl reservation) {
            this.reservation = reservation != null ? reservation.build() : null;
        }

        @Override
        public DescribeReservationResponse build() {
            return new DescribeReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
