/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddFlowSourcesResponse extends MediaConnectResponse implements
        ToCopyableBuilder<AddFlowSourcesResponse.Builder, AddFlowSourcesResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(AddFlowSourcesResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField
            .<List<Source>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(AddFlowSourcesResponse::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Source> builder(MarshallingType.SDK_POJO)
                                            .constructor(Source::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, SOURCES_FIELD));

    private final String flowArn;

    private final List<Source> sources;

    private AddFlowSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.sources = builder.sources;
    }

    /**
     * The ARN of the flow that these sources were added to.
     * 
     * @return The ARN of the flow that these sources were added to.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * The details of the newly added sources.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details of the newly added sources.
     */
    public final List<Source> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowSourcesResponse)) {
            return false;
        }
        AddFlowSourcesResponse other = (AddFlowSourcesResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddFlowSourcesResponse").add("FlowArn", flowArn())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddFlowSourcesResponse, T> g) {
        return obj -> g.apply((AddFlowSourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, AddFlowSourcesResponse> {
        /**
         * The ARN of the flow that these sources were added to.
         * 
         * @param flowArn
         *        The ARN of the flow that these sources were added to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The details of the newly added sources.
         * 
         * @param sources
         *        The details of the newly added sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<Source> sources);

        /**
         * The details of the newly added sources.
         * 
         * @param sources
         *        The details of the newly added sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Source... sources);

        /**
         * The details of the newly added sources. This is a convenience that creates an instance of the {@link List
         * <Source>.Builder} avoiding the need to create one manually via {@link List<Source>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Source>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<Source>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<Source>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<Source>)
         */
        Builder sources(Consumer<Source.Builder>... sources);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String flowArn;

        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowSourcesResponse model) {
            super(model);
            flowArn(model.flowArn);
            sources(model.sources);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Collection<Source.Builder> getSources() {
            if (sources instanceof SdkAutoConstructList) {
                return null;
            }
            return sources != null ? sources.stream().map(Source::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = ___listOfSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder>... sources) {
            sources(Stream.of(sources).map(c -> Source.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = ___listOfSourceCopier.copyFromBuilder(sources);
        }

        @Override
        public AddFlowSourcesResponse build() {
            return new AddFlowSourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
