/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcInterface> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VpcInterface.getter(VpcInterface::name)).setter(VpcInterface.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceIds").getter(VpcInterface.getter(VpcInterface::networkInterfaceIds)).setter(VpcInterface.setter(Builder::networkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(VpcInterface.getter(VpcInterface::roleArn)).setter(VpcInterface.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(VpcInterface.getter(VpcInterface::securityGroupIds)).setter(VpcInterface.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(VpcInterface.getter(VpcInterface::subnetId)).setter(VpcInterface.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NETWORK_INTERFACE_IDS_FIELD, ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> networkInterfaceIds;
    private final String roleArn;
    private final List<String> securityGroupIds;
    private final String subnetId;

    private VpcInterface(BuilderImpl builder) {
        this.name = builder.name;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.roleArn = builder.roleArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
    }

    public String name() {
        return this.name;
    }

    public boolean hasNetworkInterfaceIds() {
        return this.networkInterfaceIds != null && !(this.networkInterfaceIds instanceof SdkAutoConstructList);
    }

    public List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcInterface)) {
            return false;
        }
        VpcInterface other = (VpcInterface)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public String toString() {
        return ToString.builder((String)"VpcInterface").add("Name", (Object)this.name()).add("NetworkInterfaceIds", this.networkInterfaceIds()).add("RoleArn", (Object)this.roleArn()).add("SecurityGroupIds", this.securityGroupIds()).add("SubnetId", (Object)this.subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceIds()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcInterface, T> g) {
        return obj -> g.apply((VpcInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcInterface model) {
            this.name(model.name);
            this.networkInterfaceIds(model.networkInterfaceIds);
            this.roleArn(model.roleArn);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return this.networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ___listOf__stringCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ___listOf__stringCopier.copy(networkInterfaceIds);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public VpcInterface build() {
            return new VpcInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcInterface> {
        public Builder name(String var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder roleArn(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);
    }
}

