/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Flow;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.Messages;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFlowResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, DescribeFlowResponse> {
    private static final SdkField<Flow> FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Flow").getter(DescribeFlowResponse.getter(DescribeFlowResponse::flow)).setter(DescribeFlowResponse.setter(Builder::flow)).constructor(Flow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flow").build()}).build();
    private static final SdkField<Messages> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Messages").getter(DescribeFlowResponse.getter(DescribeFlowResponse::messages)).setter(DescribeFlowResponse.setter(Builder::messages)).constructor(Messages::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_FIELD, MESSAGES_FIELD));
    private final Flow flow;
    private final Messages messages;

    private DescribeFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flow = builder.flow;
        this.messages = builder.messages;
    }

    public Flow flow() {
        return this.flow;
    }

    public Messages messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flow());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowResponse)) {
            return false;
        }
        DescribeFlowResponse other = (DescribeFlowResponse)((Object)obj);
        return Objects.equals(this.flow(), other.flow()) && Objects.equals(this.messages(), other.messages());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFlowResponse").add("Flow", (Object)this.flow()).add("Messages", (Object)this.messages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Flow": {
                return Optional.ofNullable(clazz.cast(this.flow()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowResponse, T> g) {
        return obj -> g.apply((DescribeFlowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private Flow flow;
        private Messages messages;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowResponse model) {
            super(model);
            this.flow(model.flow);
            this.messages(model.messages);
        }

        public final Flow.Builder getFlow() {
            return this.flow != null ? this.flow.toBuilder() : null;
        }

        @Override
        public final Builder flow(Flow flow) {
            this.flow = flow;
            return this;
        }

        public final void setFlow(Flow.BuilderImpl flow) {
            this.flow = flow != null ? flow.build() : null;
        }

        public final Messages.Builder getMessages() {
            return this.messages != null ? this.messages.toBuilder() : null;
        }

        @Override
        public final Builder messages(Messages messages) {
            this.messages = messages;
            return this;
        }

        public final void setMessages(Messages.BuilderImpl messages) {
            this.messages = messages != null ? messages.build() : null;
        }

        @Override
        public DescribeFlowResponse build() {
            return new DescribeFlowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFlowResponse> {
        public Builder flow(Flow var1);

        default public Builder flow(Consumer<Flow.Builder> flow) {
            return this.flow((Flow)((Flow.Builder)Flow.builder().applyMutation(flow)).build());
        }

        public Builder messages(Messages var1);

        default public Builder messages(Consumer<Messages.Builder> messages) {
            return this.messages((Messages)((Messages.Builder)Messages.builder().applyMutation(messages)).build());
        }
    }
}

