/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container of the transaction output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactionOutputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<TransactionOutputItem.Builder, TransactionOutputItem> {
    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionHash").getter(getter(TransactionOutputItem::transactionHash))
            .setter(setter(Builder::transactionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionId").getter(getter(TransactionOutputItem::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()).build();

    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(TransactionOutputItem::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<Instant> TRANSACTION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("transactionTimestamp").getter(getter(TransactionOutputItem::transactionTimestamp))
            .setter(setter(Builder::transactionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionTimestamp").build())
            .build();

    private static final SdkField<String> CONFIRMATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("confirmationStatus").getter(getter(TransactionOutputItem::confirmationStatusAsString))
            .setter(setter(Builder::confirmationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_HASH_FIELD,
            TRANSACTION_ID_FIELD, NETWORK_FIELD, TRANSACTION_TIMESTAMP_FIELD, CONFIRMATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transactionHash;

    private final String transactionId;

    private final String network;

    private final Instant transactionTimestamp;

    private final String confirmationStatus;

    private TransactionOutputItem(BuilderImpl builder) {
        this.transactionHash = builder.transactionHash;
        this.transactionId = builder.transactionId;
        this.network = builder.network;
        this.transactionTimestamp = builder.transactionTimestamp;
        this.confirmationStatus = builder.confirmationStatus;
    }

    /**
     * <p>
     * The hash of a transaction. It is generated when a transaction is created.
     * </p>
     * 
     * @return The hash of a transaction. It is generated when a transaction is created.
     */
    public final String transactionHash() {
        return transactionHash;
    }

    /**
     * <p>
     * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     * </p>
     * 
     * @return The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    /**
     * <p>
     * The time when the transaction occurred.
     * </p>
     * 
     * @return The time when the transaction occurred.
     */
    public final Instant transactionTimestamp() {
        return transactionTimestamp;
    }

    /**
     * <p>
     * Specifies whether to list transactions that have not reached Finality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confirmationStatus} will return {@link ConfirmationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #confirmationStatusAsString}.
     * </p>
     * 
     * @return Specifies whether to list transactions that have not reached Finality.
     * @see ConfirmationStatus
     */
    public final ConfirmationStatus confirmationStatus() {
        return ConfirmationStatus.fromValue(confirmationStatus);
    }

    /**
     * <p>
     * Specifies whether to list transactions that have not reached Finality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confirmationStatus} will return {@link ConfirmationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #confirmationStatusAsString}.
     * </p>
     * 
     * @return Specifies whether to list transactions that have not reached Finality.
     * @see ConfirmationStatus
     */
    public final String confirmationStatusAsString() {
        return confirmationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transactionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionOutputItem)) {
            return false;
        }
        TransactionOutputItem other = (TransactionOutputItem) obj;
        return Objects.equals(transactionHash(), other.transactionHash())
                && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(networkAsString(), other.networkAsString())
                && Objects.equals(transactionTimestamp(), other.transactionTimestamp())
                && Objects.equals(confirmationStatusAsString(), other.confirmationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransactionOutputItem").add("TransactionHash", transactionHash())
                .add("TransactionId", transactionId()).add("Network", networkAsString())
                .add("TransactionTimestamp", transactionTimestamp()).add("ConfirmationStatus", confirmationStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transactionHash":
            return Optional.ofNullable(clazz.cast(transactionHash()));
        case "transactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        case "transactionTimestamp":
            return Optional.ofNullable(clazz.cast(transactionTimestamp()));
        case "confirmationStatus":
            return Optional.ofNullable(clazz.cast(confirmationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transactionHash", TRANSACTION_HASH_FIELD);
        map.put("transactionId", TRANSACTION_ID_FIELD);
        map.put("network", NETWORK_FIELD);
        map.put("transactionTimestamp", TRANSACTION_TIMESTAMP_FIELD);
        map.put("confirmationStatus", CONFIRMATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransactionOutputItem, T> g) {
        return obj -> g.apply((TransactionOutputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransactionOutputItem> {
        /**
         * <p>
         * The hash of a transaction. It is generated when a transaction is created.
         * </p>
         * 
         * @param transactionHash
         *        The hash of a transaction. It is generated when a transaction is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionHash(String transactionHash);

        /**
         * <p>
         * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         * </p>
         * 
         * @param transactionId
         *        The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        /**
         * <p>
         * The time when the transaction occurred.
         * </p>
         * 
         * @param transactionTimestamp
         *        The time when the transaction occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionTimestamp(Instant transactionTimestamp);

        /**
         * <p>
         * Specifies whether to list transactions that have not reached Finality.
         * </p>
         * 
         * @param confirmationStatus
         *        Specifies whether to list transactions that have not reached Finality.
         * @see ConfirmationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfirmationStatus
         */
        Builder confirmationStatus(String confirmationStatus);

        /**
         * <p>
         * Specifies whether to list transactions that have not reached Finality.
         * </p>
         * 
         * @param confirmationStatus
         *        Specifies whether to list transactions that have not reached Finality.
         * @see ConfirmationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfirmationStatus
         */
        Builder confirmationStatus(ConfirmationStatus confirmationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String transactionHash;

        private String transactionId;

        private String network;

        private Instant transactionTimestamp;

        private String confirmationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionOutputItem model) {
            transactionHash(model.transactionHash);
            transactionId(model.transactionId);
            network(model.network);
            transactionTimestamp(model.transactionTimestamp);
            confirmationStatus(model.confirmationStatus);
        }

        public final String getTransactionHash() {
            return transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final Instant getTransactionTimestamp() {
            return transactionTimestamp;
        }

        public final void setTransactionTimestamp(Instant transactionTimestamp) {
            this.transactionTimestamp = transactionTimestamp;
        }

        @Override
        public final Builder transactionTimestamp(Instant transactionTimestamp) {
            this.transactionTimestamp = transactionTimestamp;
            return this;
        }

        public final String getConfirmationStatus() {
            return confirmationStatus;
        }

        public final void setConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
        }

        @Override
        public final Builder confirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        @Override
        public final Builder confirmationStatus(ConfirmationStatus confirmationStatus) {
            this.confirmationStatus(confirmationStatus == null ? null : confirmationStatus.toString());
            return this;
        }

        @Override
        public TransactionOutputItem build() {
            return new TransactionOutputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
