/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTokenBalanceRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<GetTokenBalanceRequest.Builder, GetTokenBalanceRequest> {
    private static final SdkField<TokenIdentifier> TOKEN_IDENTIFIER_FIELD = SdkField
            .<TokenIdentifier> builder(MarshallingType.SDK_POJO).memberName("tokenIdentifier")
            .getter(getter(GetTokenBalanceRequest::tokenIdentifier)).setter(setter(Builder::tokenIdentifier))
            .constructor(TokenIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenIdentifier").build()).build();

    private static final SdkField<OwnerIdentifier> OWNER_IDENTIFIER_FIELD = SdkField
            .<OwnerIdentifier> builder(MarshallingType.SDK_POJO).memberName("ownerIdentifier")
            .getter(getter(GetTokenBalanceRequest::ownerIdentifier)).setter(setter(Builder::ownerIdentifier))
            .constructor(OwnerIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerIdentifier").build()).build();

    private static final SdkField<BlockchainInstant> AT_BLOCKCHAIN_INSTANT_FIELD = SdkField
            .<BlockchainInstant> builder(MarshallingType.SDK_POJO).memberName("atBlockchainInstant")
            .getter(getter(GetTokenBalanceRequest::atBlockchainInstant)).setter(setter(Builder::atBlockchainInstant))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atBlockchainInstant").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_IDENTIFIER_FIELD,
            OWNER_IDENTIFIER_FIELD, AT_BLOCKCHAIN_INSTANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TokenIdentifier tokenIdentifier;

    private final OwnerIdentifier ownerIdentifier;

    private final BlockchainInstant atBlockchainInstant;

    private GetTokenBalanceRequest(BuilderImpl builder) {
        super(builder);
        this.tokenIdentifier = builder.tokenIdentifier;
        this.ownerIdentifier = builder.ownerIdentifier;
        this.atBlockchainInstant = builder.atBlockchainInstant;
    }

    /**
     * <p>
     * The container for the identifier for the token, including the unique token ID and its blockchain network.
     * </p>
     * 
     * @return The container for the identifier for the token, including the unique token ID and its blockchain network.
     */
    public final TokenIdentifier tokenIdentifier() {
        return tokenIdentifier;
    }

    /**
     * <p>
     * The container for the identifier for the owner.
     * </p>
     * 
     * @return The container for the identifier for the owner.
     */
    public final OwnerIdentifier ownerIdentifier() {
        return ownerIdentifier;
    }

    /**
     * <p>
     * The time for when the TokenBalance is requested or the current time if a time is not provided in the request.
     * </p>
     * <note>
     * <p>
     * This time will only be recorded up to the second.
     * </p>
     * </note>
     * 
     * @return The time for when the TokenBalance is requested or the current time if a time is not provided in the
     *         request.</p> <note>
     *         <p>
     *         This time will only be recorded up to the second.
     *         </p>
     */
    public final BlockchainInstant atBlockchainInstant() {
        return atBlockchainInstant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tokenIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(ownerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(atBlockchainInstant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTokenBalanceRequest)) {
            return false;
        }
        GetTokenBalanceRequest other = (GetTokenBalanceRequest) obj;
        return Objects.equals(tokenIdentifier(), other.tokenIdentifier())
                && Objects.equals(ownerIdentifier(), other.ownerIdentifier())
                && Objects.equals(atBlockchainInstant(), other.atBlockchainInstant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTokenBalanceRequest").add("TokenIdentifier", tokenIdentifier())
                .add("OwnerIdentifier", ownerIdentifier()).add("AtBlockchainInstant", atBlockchainInstant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tokenIdentifier":
            return Optional.ofNullable(clazz.cast(tokenIdentifier()));
        case "ownerIdentifier":
            return Optional.ofNullable(clazz.cast(ownerIdentifier()));
        case "atBlockchainInstant":
            return Optional.ofNullable(clazz.cast(atBlockchainInstant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tokenIdentifier", TOKEN_IDENTIFIER_FIELD);
        map.put("ownerIdentifier", OWNER_IDENTIFIER_FIELD);
        map.put("atBlockchainInstant", AT_BLOCKCHAIN_INSTANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTokenBalanceRequest, T> g) {
        return obj -> g.apply((GetTokenBalanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTokenBalanceRequest> {
        /**
         * <p>
         * The container for the identifier for the token, including the unique token ID and its blockchain network.
         * </p>
         * 
         * @param tokenIdentifier
         *        The container for the identifier for the token, including the unique token ID and its blockchain
         *        network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenIdentifier(TokenIdentifier tokenIdentifier);

        /**
         * <p>
         * The container for the identifier for the token, including the unique token ID and its blockchain network.
         * </p>
         * This is a convenience method that creates an instance of the {@link TokenIdentifier.Builder} avoiding the
         * need to create one manually via {@link TokenIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #tokenIdentifier(TokenIdentifier)}.
         * 
         * @param tokenIdentifier
         *        a consumer that will call methods on {@link TokenIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokenIdentifier(TokenIdentifier)
         */
        default Builder tokenIdentifier(Consumer<TokenIdentifier.Builder> tokenIdentifier) {
            return tokenIdentifier(TokenIdentifier.builder().applyMutation(tokenIdentifier).build());
        }

        /**
         * <p>
         * The container for the identifier for the owner.
         * </p>
         * 
         * @param ownerIdentifier
         *        The container for the identifier for the owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIdentifier(OwnerIdentifier ownerIdentifier);

        /**
         * <p>
         * The container for the identifier for the owner.
         * </p>
         * This is a convenience method that creates an instance of the {@link OwnerIdentifier.Builder} avoiding the
         * need to create one manually via {@link OwnerIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OwnerIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #ownerIdentifier(OwnerIdentifier)}.
         * 
         * @param ownerIdentifier
         *        a consumer that will call methods on {@link OwnerIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerIdentifier(OwnerIdentifier)
         */
        default Builder ownerIdentifier(Consumer<OwnerIdentifier.Builder> ownerIdentifier) {
            return ownerIdentifier(OwnerIdentifier.builder().applyMutation(ownerIdentifier).build());
        }

        /**
         * <p>
         * The time for when the TokenBalance is requested or the current time if a time is not provided in the request.
         * </p>
         * <note>
         * <p>
         * This time will only be recorded up to the second.
         * </p>
         * </note>
         * 
         * @param atBlockchainInstant
         *        The time for when the TokenBalance is requested or the current time if a time is not provided in the
         *        request.</p> <note>
         *        <p>
         *        This time will only be recorded up to the second.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant);

        /**
         * <p>
         * The time for when the TokenBalance is requested or the current time if a time is not provided in the request.
         * </p>
         * <note>
         * <p>
         * This time will only be recorded up to the second.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder}
         * avoiding the need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #atBlockchainInstant(BlockchainInstant)}.
         * 
         * @param atBlockchainInstant
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #atBlockchainInstant(BlockchainInstant)
         */
        default Builder atBlockchainInstant(Consumer<BlockchainInstant.Builder> atBlockchainInstant) {
            return atBlockchainInstant(BlockchainInstant.builder().applyMutation(atBlockchainInstant).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private TokenIdentifier tokenIdentifier;

        private OwnerIdentifier ownerIdentifier;

        private BlockchainInstant atBlockchainInstant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTokenBalanceRequest model) {
            super(model);
            tokenIdentifier(model.tokenIdentifier);
            ownerIdentifier(model.ownerIdentifier);
            atBlockchainInstant(model.atBlockchainInstant);
        }

        public final TokenIdentifier.Builder getTokenIdentifier() {
            return tokenIdentifier != null ? tokenIdentifier.toBuilder() : null;
        }

        public final void setTokenIdentifier(TokenIdentifier.BuilderImpl tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier != null ? tokenIdentifier.build() : null;
        }

        @Override
        public final Builder tokenIdentifier(TokenIdentifier tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        public final OwnerIdentifier.Builder getOwnerIdentifier() {
            return ownerIdentifier != null ? ownerIdentifier.toBuilder() : null;
        }

        public final void setOwnerIdentifier(OwnerIdentifier.BuilderImpl ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier != null ? ownerIdentifier.build() : null;
        }

        @Override
        public final Builder ownerIdentifier(OwnerIdentifier ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier;
            return this;
        }

        public final BlockchainInstant.Builder getAtBlockchainInstant() {
            return atBlockchainInstant != null ? atBlockchainInstant.toBuilder() : null;
        }

        public final void setAtBlockchainInstant(BlockchainInstant.BuilderImpl atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant != null ? atBlockchainInstant.build() : null;
        }

        @Override
        public final Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTokenBalanceRequest build() {
            return new GetTokenBalanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
